import responses
import requests
import urllib.parse
import json
import unittest
from vkmix import VkMix

class TestVkMixGetServices(unittest.TestCase):
    success_data = json.loads(r"""
{"response":{"instagram":[{"id":1,"name_ru":"\u041b\u0430\u0439\u043a\u0438","description_ru":"\u0411\u043e\u0442\u044b \u0441 \u043f\u043e\u0441\u0442\u0430\u043c\u0438 . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":3,"points_max":6,"network":"instagram","type":"likes"},{"id":2,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","description_ru":"\u0411\u043e\u0442\u044b \u0441 \u043f\u043e\u0441\u0442\u0430\u043c\u0438 . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":3,"points_max":6,"network":"instagram","type":"subscribers"},{"id":5,"name_ru":"\u041b\u0430\u0439\u043a\u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435","description_ru":"\u0411\u043e\u0442\u044b \u0441 \u043f\u043e\u0441\u0442\u0430\u043c\u0438 \u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430\u043c\u0438, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":4,"points_max":6,"network":"instagram","type":"likes"},{"id":6,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435","description_ru":"\u0411\u043e\u0442\u044b \u0441 \u043f\u043e\u0441\u0442\u0430\u043c\u0438 \u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430\u043c\u0438, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":4,"points_max":6,"network":"instagram","type":"subscribers"},{"id":28,"name_ru":"\u041b\u0430\u0439\u043a\u0438 \u0416\u0438\u0432\u044b\u0435","description_ru":"\u041f\u0440\u043e\u0444\u0438\u043b\u0438 \u0436\u0438\u0432\u044b\u0445 \u043b\u044e\u0434\u0435\u0439, \u043f\u0440\u0435\u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e \u0441\u043d\u0433.","points_min":10,"points_max":15,"network":"instagram","type":"likes"},{"id":29,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u0416\u0438\u0432\u044b\u0435","description_ru":"\u041f\u0440\u043e\u0444\u0438\u043b\u0438 \u0436\u0438\u0432\u044b\u0445 \u043b\u044e\u0434\u0435\u0439, \u043f\u0440\u0435\u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e \u0441\u043d\u0433.","points_min":10,"points_max":15,"network":"instagram","type":"subscribers"}],"vk":[{"id":9,"name_ru":"\u041b\u0430\u0439\u043a\u0438","description_ru":"\u041b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c, \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u044e \u0438\u043b\u0438 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0412\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0435","points_min":2,"points_max":6,"network":"vk","type":"likes"},{"id":10,"name_ru":"\u0420\u0435\u043f\u043e\u0441\u0442\u044b","description_ru":"\u0420\u0435\u043f\u043e\u0441\u0442\u044b \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c, \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u044e \u0438\u043b\u0438 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0412\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0435","points_min":4,"points_max":6,"network":"vk","type":"reposts"},{"id":11,"name_ru":"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438","description_ru":"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c, \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u044e \u0438\u043b\u0438 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0412\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0435","points_min":7,"points_max":9,"network":"vk","type":"comments"},{"id":12,"name_ru":"\u0414\u0440\u0443\u0437\u044c\u044f","description_ru":"\u0414\u0440\u0443\u0437\u044c\u044f \u043d\u0430 \u043b\u0438\u0447\u043d\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0412\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0435","points_min":4,"points_max":6,"network":"vk","type":"friends"},{"id":13,"name_ru":"\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0438","description_ru":"\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0438 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443 \u0438\u043b\u0438 \u043f\u0443\u0431\u043b\u0438\u0447\u043d\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0412\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0435","points_min":4,"points_max":7,"network":"vk","type":"groups"}],"tiktok":[{"id":14,"name_ru":"\u041b\u0430\u0439\u043a\u0438","description_ru":"\u041b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0432 Tiktok","points_min":3,"points_max":5,"network":"tiktok","type":"likes"},{"id":15,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","description_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043d\u0430 Tiktok \u0430\u043a\u043a\u0430\u0443\u043d\u0442","points_min":3,"points_max":5,"network":"tiktok","type":"subscribers"},{"id":16,"name_ru":"\u041b\u0430\u0439\u043a\u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435","description_ru":"\u041a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0432 Tiktok","points_min":3,"points_max":5,"network":"tiktok","type":"likes"},{"id":17,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435","description_ru":"\u041a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043d\u0430 Tiktok \u0430\u043a\u043a\u0430\u0443\u043d\u0442","points_min":6,"points_max":8,"network":"tiktok","type":"subscribers"}],"youtube":[{"id":18,"name_ru":"\u041b\u0430\u0439\u043a\u0438","description_ru":"\u041b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0432 YouTube . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":4,"points_max":9,"network":"youtube","type":"likes"},{"id":19,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","description_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043d\u0430 YouTube \u043a\u0430\u043d\u0430\u043b . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":4,"points_max":9,"network":"youtube","type":"friends"},{"id":20,"name_ru":"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438","description_ru":"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u043d\u0430 \u0432\u0438\u0434\u0435\u043e\u0437\u0430\u043f\u0438\u0441\u044c \u0432 YouTube","points_min":10,"points_max":15,"network":"youtube","type":"comments"}],"telegram":[{"id":21,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","description_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438 \u043d\u0430 \u043a\u0430\u043d\u0430\u043b Telegram","points_min":4,"points_max":7,"network":"telegram","type":"subscribers"}],"ok":[{"id":22,"name_ru":"\u041a\u043b\u0430\u0441\u0441\u044b","description_ru":"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f.","points_min":3,"points_max":6,"network":"ok","type":"likes"},{"id":23,"name_ru":"\u0414\u0440\u0443\u0437\u044c\u044f","description_ru":"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f.","points_min":3,"points_max":6,"network":"ok","type":"friends"},{"id":24,"name_ru":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","description_ru":"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f.","points_min":3,"points_max":6,"network":"ok","type":"groups"}],"twitter":[{"id":25,"name_ru":"\u0420\u0435\u0442\u0432\u0438\u0442\u044b","description_ru":"\u0420\u0435\u0442\u0432\u0438\u0442\u044b \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 Twitter . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":3,"points_max":10,"network":"twitter","type":"retweets"},{"id":26,"name_ru":"\u0424\u043e\u043b\u043b\u043e\u0432\u0435\u0440\u044b","description_ru":"\u0424\u043e\u043b\u043b\u043e\u0432\u0435\u0440\u044b \u043d\u0430 Twitter \u0430\u043a\u043a\u0430\u0443\u043d\u0442 . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":3,"points_max":10,"network":"twitter","type":"followers"},{"id":27,"name_ru":"\u041b\u0430\u0439\u043a\u0438","description_ru":"\u041b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 Twitter . \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f","points_min":3,"points_max":10,"network":"twitter","type":"favorites"}]}}
""".strip())
    
    def response_callback(self, resp):
        resp.callback_processed = True
        args = {}
        try:
            args = urllib.parse.parse_qs(urllib.parse.urlparse(resp.url)[4])
        except AttributeError: pass
        except KeyError: pass
        self.assertIn("api_token", args)
        self.assertEqual(args["api_token"][0], "mykey")
        return resp

    def test_getServices(self):
        with responses.RequestsMock(response_callback=self.response_callback) as m:
            m.add(responses.GET, "https://vkmix.com/api/2/getServices", json=self.success_data)
            vkm = VkMix(api_token="mykey")
            data = vkm.getServices()
            # self.assertEqual(m.assert_call_count("https://vkmix.com/api/2/getServices", 1), True) # no support query string?
            self.assertIn("vk", data)
            self.assertIn("instagram", data)

if __name__ == "__main__":
    unittest.main()
    