# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationUrlDispatchRulesArgs', 'ApplicationUrlDispatchRules']

@pulumi.input_type
class ApplicationUrlDispatchRulesArgs:
    def __init__(__self__, *,
                 dispatch_rules: pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]],
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplicationUrlDispatchRules resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "dispatch_rules", dispatch_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @dispatch_rules.setter
    def dispatch_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]):
        pulumi.set(self, "dispatch_rules", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ApplicationUrlDispatchRulesState:
    def __init__(__self__, *,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplicationUrlDispatchRules resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if dispatch_rules is not None:
            pulumi.set(__self__, "dispatch_rules", dispatch_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @dispatch_rules.setter
    def dispatch_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]):
        pulumi.set(self, "dispatch_rules", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ApplicationUrlDispatchRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Rules to match an HTTP request and dispatch that request to a service.

        To get more information about ApplicationUrlDispatchRules, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps#UrlDispatchRule)

        ## Example Usage
        ### App Engine Application Url Dispatch Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket")
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/appengine/hello-world.zip"))
        admin_v3 = gcp.appengine.StandardAppVersion("adminV3",
            version_id="v3",
            service="admin",
            runtime="nodejs10",
            entrypoint=gcp.appengine.StandardAppVersionEntrypointArgs(
                shell="node ./app.js",
            ),
            deployment=gcp.appengine.StandardAppVersionDeploymentArgs(
                zip=gcp.appengine.StandardAppVersionDeploymentZipArgs(
                    source_url=pulumi.Output.all(bucket.name, object.name).apply(lambda bucketName, objectName: f"https://storage.googleapis.com/{bucket_name}/{object_name}"),
                ),
            ),
            env_variables={
                "port": "8080",
            },
            noop_on_destroy=True)
        web_service = gcp.appengine.ApplicationUrlDispatchRules("webService", dispatch_rules=[
            gcp.appengine.ApplicationUrlDispatchRulesDispatchRuleArgs(
                domain="*",
                path="/*",
                service="default",
            ),
            gcp.appengine.ApplicationUrlDispatchRulesDispatchRuleArgs(
                domain="*",
                path="/admin/*",
                service=admin_v3.service,
            ),
        ])
        ```

        ## Import

        ApplicationUrlDispatchRules can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationUrlDispatchRulesDispatchRuleArgs']]]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationUrlDispatchRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Rules to match an HTTP request and dispatch that request to a service.

        To get more information about ApplicationUrlDispatchRules, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps#UrlDispatchRule)

        ## Example Usage
        ### App Engine Application Url Dispatch Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket")
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/appengine/hello-world.zip"))
        admin_v3 = gcp.appengine.StandardAppVersion("adminV3",
            version_id="v3",
            service="admin",
            runtime="nodejs10",
            entrypoint=gcp.appengine.StandardAppVersionEntrypointArgs(
                shell="node ./app.js",
            ),
            deployment=gcp.appengine.StandardAppVersionDeploymentArgs(
                zip=gcp.appengine.StandardAppVersionDeploymentZipArgs(
                    source_url=pulumi.Output.all(bucket.name, object.name).apply(lambda bucketName, objectName: f"https://storage.googleapis.com/{bucket_name}/{object_name}"),
                ),
            ),
            env_variables={
                "port": "8080",
            },
            noop_on_destroy=True)
        web_service = gcp.appengine.ApplicationUrlDispatchRules("webService", dispatch_rules=[
            gcp.appengine.ApplicationUrlDispatchRulesDispatchRuleArgs(
                domain="*",
                path="/*",
                service="default",
            ),
            gcp.appengine.ApplicationUrlDispatchRulesDispatchRuleArgs(
                domain="*",
                path="/admin/*",
                service=admin_v3.service,
            ),
        ])
        ```

        ## Import

        ApplicationUrlDispatchRules can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationUrlDispatchRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationUrlDispatchRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationUrlDispatchRulesArgs.__new__(ApplicationUrlDispatchRulesArgs)

            if dispatch_rules is None and not opts.urn:
                raise TypeError("Missing required property 'dispatch_rules'")
            __props__.__dict__["dispatch_rules"] = dispatch_rules
            __props__.__dict__["project"] = project
        super(ApplicationUrlDispatchRules, __self__).__init__(
            'gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ApplicationUrlDispatchRules':
        """
        Get an existing ApplicationUrlDispatchRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationUrlDispatchRulesDispatchRuleArgs']]]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationUrlDispatchRulesState.__new__(_ApplicationUrlDispatchRulesState)

        __props__.__dict__["dispatch_rules"] = dispatch_rules
        __props__.__dict__["project"] = project
        return ApplicationUrlDispatchRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> pulumi.Output[Sequence['outputs.ApplicationUrlDispatchRulesDispatchRule']]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

