# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EntityTypeEntityArgs',
    'FulfillmentFeatureArgs',
    'FulfillmentGenericWebServiceArgs',
    'IntentFollowupIntentInfoArgs',
]

@pulumi.input_type
class EntityTypeEntityArgs:
    def __init__(__self__, *,
                 synonyms: pulumi.Input[Sequence[pulumi.Input[str]]],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: A collection of value synonyms. For example, if the entity type is vegetable, and value is scallions, a synonym
               could be green onions.
               For KIND_LIST entity types:
               * This collection must contain exactly one synonym equal to value.
        :param pulumi.Input[str] value: The primary value associated with this entity entry. For example, if the entity type is vegetable, the value
               could be scallions.
               For KIND_MAP entity types:
               * A reference value to be used in place of synonyms.
               For KIND_LIST entity types:
               * A string that can contain references to other entity types (with or without aliases).
        """
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of value synonyms. For example, if the entity type is vegetable, and value is scallions, a synonym
        could be green onions.
        For KIND_LIST entity types:
        * This collection must contain exactly one synonym equal to value.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The primary value associated with this entity entry. For example, if the entity type is vegetable, the value
        could be scallions.
        For KIND_MAP entity types:
        * A reference value to be used in place of synonyms.
        For KIND_LIST entity types:
        * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FulfillmentFeatureArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: The type of the feature that enabled for fulfillment.
               * SMALLTALK: Fulfillment is enabled for SmallTalk.
               Possible values are `SMALLTALK`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the feature that enabled for fulfillment.
        * SMALLTALK: Fulfillment is enabled for SmallTalk.
        Possible values are `SMALLTALK`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FulfillmentGenericWebServiceArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] uri: The fulfillment URI for receiving POST requests. It must use https protocol.
        :param pulumi.Input[str] password: The password for HTTP Basic authentication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] request_headers: The HTTP request headers to send together with fulfillment requests.
        :param pulumi.Input[str] username: The user name for HTTP Basic authentication.
        """
        pulumi.set(__self__, "uri", uri)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The fulfillment URI for receiving POST requests. It must use https protocol.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for HTTP Basic authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The HTTP request headers to send together with fulfillment requests.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for HTTP Basic authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class IntentFollowupIntentInfoArgs:
    def __init__(__self__, *,
                 followup_intent_name: Optional[pulumi.Input[str]] = None,
                 parent_followup_intent_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] parent_followup_intent_name: The unique identifier of the parent intent in the chain of followup intents.
               Format: projects/<Project ID>/agent/intents/<Intent ID>.
        """
        if followup_intent_name is not None:
            pulumi.set(__self__, "followup_intent_name", followup_intent_name)
        if parent_followup_intent_name is not None:
            pulumi.set(__self__, "parent_followup_intent_name", parent_followup_intent_name)

    @property
    @pulumi.getter(name="followupIntentName")
    def followup_intent_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "followup_intent_name")

    @followup_intent_name.setter
    def followup_intent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "followup_intent_name", value)

    @property
    @pulumi.getter(name="parentFollowupIntentName")
    def parent_followup_intent_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the parent intent in the chain of followup intents.
        Format: projects/<Project ID>/agent/intents/<Intent ID>.
        """
        return pulumi.get(self, "parent_followup_intent_name")

    @parent_followup_intent_name.setter
    def parent_followup_intent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_followup_intent_name", value)


