window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "grib2io", "modulename": "grib2io", "type": "module", "doc": "<h1 id=\"introduction\">Introduction</h1>\n\n<p>grib2io is a Python package that provides an interface to the <a href=\"https://github.com/NOAA-EMC/NCEPLIBS-g2c\">NCEP GRIB2 C (g2c)</a> \nlibrary for the purpose of reading and writing WMO GRIdded Binary, Edition 2 (GRIB2) messages. A physical file can contain one \nor more GRIB2 messages.</p>\n\n<p>GRIB2 file IO is performed directly in Python.  The unpacking/packing of GRIB2 integer, coded metadata and data sections is performed \nby the g2c library functions via the g2clib Cython wrapper module.  The decoding/encoding of GRIB2 metadata is translated into more \ndescriptive, plain language metadata by looking up the integer code values against the appropriate GRIB2 code tables.  These code tables \nare a part of the grib2io module.</p>\n"}, {"fullname": "grib2io.open", "modulename": "grib2io", "qualname": "open", "type": "class", "doc": "<p>GRIB2 File Object.  A physical file can contain one or more GRIB2 messages.  When instantiated,\nclass <code>grib2io.open</code>, the file named <code>filename</code> is opened for reading (<code>mode = 'r'</code>) and is\nautomatically indexed.  The indexing procedure reads some of the GRIB2 metadata for all GRIB2 Messages.</p>\n\n<p>A GRIB2 Message may contain submessages whereby Section 2-7 can be repeated.  grib2io accommodates\nfor this by flattening any GRIB2 submessages into multiple individual messages.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p><strong><code>mode</code></strong>: File IO mode of opening the file.</p>\n\n<p><strong><code>name</code></strong>: Full path name of the GRIB2 file.</p>\n\n<p><strong><code>messages</code></strong>: Count of GRIB2 Messages contained in the file.</p>\n\n<p><strong><code>current_message</code></strong>: Current position of the file in units of GRIB2 Messages.</p>\n\n<p><strong><code>size</code></strong>: Size of the file in units of bytes.</p>\n\n<p><strong><code>closed</code></strong> <code>True</code> is file handle is close; <code>False</code> otherwise.</p>\n\n<p><strong><code>decode</code></strong>: If <code>True</code> [DEFAULT] automatically decode metadata from unpacked \nsection data for Grib2Messages.</p>\n\n<p><strong><code>variables</code></strong>: Tuple containing a unique list of variable short names (i.e. GRIB2 abbreviation names).</p>\n\n<p><strong><code>levels</code></strong>: Tuple containing a unique list of wgrib2-formatted level/layer strings.</p>\n"}, {"fullname": "grib2io.open.__init__", "modulename": "grib2io", "qualname": "open.__init__", "type": "function", "doc": "<p><code>open</code> Constructor</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>filename</code></strong>: File name containing GRIB2 messages.</p>\n\n<p><strong><code>mode</code></strong>: File access mode where <code>r</code> opens the files for reading only;\n<code>w</code> opens the file for writing.</p>\n\n<p><strong><code>decode</code></strong>: If <code>True</code> [DEFAULT] automatically decode metadata from \nunpacked section data for Grib2Messages.</p>\n", "signature": "(self, filename, mode='r', decode=True)", "funcdef": "def"}, {"fullname": "grib2io.open.close", "modulename": "grib2io", "qualname": "open.close", "type": "function", "doc": "<p>Close the file handle</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.open.read", "modulename": "grib2io", "qualname": "open.read", "type": "function", "doc": "<p>Read num GRIB2 messages from the current position</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>num</code></strong>: integer number of GRIB2 Message to read.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>list</code></strong>: list of <code>grib2io.Grib2Message</code> instances.</p>\n", "signature": "(self, num=1)", "funcdef": "def"}, {"fullname": "grib2io.open.rewind", "modulename": "grib2io", "qualname": "open.rewind", "type": "function", "doc": "<p>Set the position of the file to zero in units of GRIB2 messages.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.open.seek", "modulename": "grib2io", "qualname": "open.seek", "type": "function", "doc": "<p>Set the position within the file in units of GRIB2 messages.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>pos</code></strong>: GRIB2 Message number to set the read pointer to.</p>\n", "signature": "(self, pos)", "funcdef": "def"}, {"fullname": "grib2io.open.tell", "modulename": "grib2io", "qualname": "open.tell", "type": "function", "doc": "<p>Returns the position of the file in units of GRIB2 Messages.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.open.select", "modulename": "grib2io", "qualname": "open.select", "type": "function", "doc": "<p>Returns a list of <code>grib2io.Grib2Message</code> instances based on the selection <strong><code>**kwargs</code></strong>.</p>\n\n<p>The following keywords are currently supported:</p>\n\n<p><strong><code>duration : int</code></strong> specifiying the time duration (in unit of hours) of a GRIB2 Message that is \ndetermined from a period of time.</p>\n\n<p><strong><code>leadTime : int</code></strong> specifying ending lead time (in units of hours) of a GRIB2 Message.</p>\n\n<p><strong><code>level : str</code></strong> wgrib2-formatted layer/level string.</p>\n\n<p><strong><code>percentile : int</code></strong> specify the percentile value.</p>\n\n<p><strong><code>refDate : int</code></strong> specifying the reference date in <code>YYYYMMDDHH[MMSS]</code> format.</p>\n\n<p><strong><code>shortName : str</code></strong> the GRIB2 <code>shortName</code>.  This is the abbreviation name found in the NCEP GRIB2 tables.</p>\n\n<p><strong><code>threshold : str</code></strong> wgrib2-formatted probability threshold string.</p>\n", "signature": "(self, **kwargs)", "funcdef": "def"}, {"fullname": "grib2io.open.write", "modulename": "grib2io", "qualname": "open.write", "type": "function", "doc": "<p>Writes a packed GRIB2 message to file.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>msg</code></strong>: instance of <code>Grib2Message</code>.</p>\n", "signature": "(self, msg)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message", "modulename": "grib2io", "qualname": "Grib2Message", "type": "class", "doc": "<p></p>\n"}, {"fullname": "grib2io.Grib2Message.__init__", "modulename": "grib2io", "qualname": "Grib2Message.__init__", "type": "function", "doc": "<p>Class Constructor. Instantiation of this class can handle a GRIB2 message from an existing \nfile or the creation of new GRIB2 message.  To create a new GRIB2 message, provide the \nappropriate values to the arguments <code>discipline</code> and <code>idsect</code>.  When these 2 arguments \nare not <code>None</code>, then a new GRIB2 message is created. NOTE: All other keyword arguments \nare ignored when a new message is created.</p>\n\n<p>...</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>msg</code></strong>: Binary string representing the GRIB2 Message read from file.</p>\n\n<p><strong><code>source</code></strong>: Source of where where this GRIB2 message originated \nfrom (i.e. the input file). This allow for interaction with the \ninstance of <code>grib2io.open</code>. Default is None.</p>\n\n<p><strong><code>num</code></strong>: integer GRIB2 Message number from <code>grib2io.open</code>. Default value is -1.</p>\n\n<p><strong><code>decode</code></strong>: If True [DEFAULT], decode GRIB2 section lists into metadata \ninstance variables.</p>\n\n<p><strong><code>discipline</code></strong>: integer GRIB2 Discipline <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table0-0.shtml\">GRIB2 Table 0.0</a></p>\n\n<p><strong><code>idsect</code></strong>: Sequence containing GRIB1 Identification Section values (Section 1).</p>\n\n<table>\n<thead>\n<tr>\n  <th style=\"text-align:center;\">Index</th>\n  <th style=\"text-align:left;\">Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td style=\"text-align:center;\">idsect[0]</td>\n  <td style=\"text-align:left;\">Id of orginating centre - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/on388/table0.html\">ON388 - Table 0</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[1]</td>\n  <td style=\"text-align:left;\">Id of orginating sub-centre - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/on388/tablec.html\">ON388 - Table C</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[2]</td>\n  <td style=\"text-align:left;\">GRIB Master Tables Version Number - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table1-0.shtml\">Code Table 1.0</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[3]</td>\n  <td style=\"text-align:left;\">GRIB Local Tables Version Number - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table1-1.shtml\">Code Table 1.1</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[4]</td>\n  <td style=\"text-align:left;\">Significance of Reference Time - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table1-2.shtml\">Code Table 1.2</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[5]</td>\n  <td style=\"text-align:left;\">Reference Time - Year (4 digits)</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[6]</td>\n  <td style=\"text-align:left;\">Reference Time - Month</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[7]</td>\n  <td style=\"text-align:left;\">Reference Time - Day</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[8]</td>\n  <td style=\"text-align:left;\">Reference Time - Hour</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[9]</td>\n  <td style=\"text-align:left;\">Reference Time - Minute</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[10]</td>\n  <td style=\"text-align:left;\">Reference Time - Second</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[11]</td>\n  <td style=\"text-align:left;\">Production status of data - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table1-3.shtml\">Code Table 1.3</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">idsect[12]</td>\n  <td style=\"text-align:left;\">Type of processed data - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table1-4.shtml\">Code Table 1.4</a></td>\n</tr>\n</tbody>\n</table>\n", "signature": "(\n    self,\n    msg=None,\n    source=None,\n    num=-1,\n    decode=True,\n    discipline=None,\n    idsect=None\n)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.unpack", "modulename": "grib2io", "qualname": "Grib2Message.unpack", "type": "function", "doc": "<p>Unpacks GRIB2 section data from the packed, binary message.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.decode", "modulename": "grib2io", "qualname": "Grib2Message.decode", "type": "function", "doc": "<p>Decode the unpacked GRIB2 integer-coded metadata in human-readable form and linked to GRIB2 tables.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.data", "modulename": "grib2io", "qualname": "Grib2Message.data", "type": "function", "doc": "<p>Returns an unpacked data grid.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>fill_value</code></strong>: Missing or masked data is filled with this value or default value given by\n<code>DEFAULT_FILL_VALUE</code></p>\n\n<p><strong><code>masked_array</code></strong>: If <code>True</code> [DEFAULT], return masked array if there is bitmap for missing \nor masked data.</p>\n\n<p><strong><code>expand</code></strong>: If <code>True</code> [DEFAULT], Reduced Gaussian grids are expanded to regular Gaussian grids.</p>\n\n<p><strong><code>order</code></strong>: If 0 [DEFAULT], nearest neighbor interpolation is used if grid has missing \nor bitmapped values. If 1, linear interpolation is used for expanding reduced Gaussian grids.</p>\n\n<p><strong><code>map_keys</code></strong>: If <code>True</code>, data values will be mapped to the string-based keys that are stored\nin the Local Use Section (section 2) of the GRIB2 Message or in a code table as specified in the\nunits (i.e. \"See Table 4.xxx\").</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>numpy.ndarray</code></strong>: A numpy.ndarray with shape (ny,nx). By default the array dtype=np.float32, \nbut could be np.int32 if Grib2Message.typeOfValues is integer.  The array dtype will be \nstring-based if map_keys=True.</p>\n", "signature": "(\n    self,\n    fill_value=9.969209968386869e+36,\n    masked_array=True,\n    expand=True,\n    order=None,\n    map_keys=False\n)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.latlons", "modulename": "grib2io", "qualname": "Grib2Message.latlons", "type": "function", "doc": "<p>Alias for <code>grib2io.Grib2Message.grid</code> method</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.grid", "modulename": "grib2io", "qualname": "Grib2Message.grid", "type": "function", "doc": "<p>Return lats,lons (in degrees) of grid. Currently can handle reg. lat/lon, \nglobal Gaussian, mercator, stereographic, lambert conformal, albers equal-area, \nspace-view and azimuthal equidistant grids.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>lats, lons : numpy.ndarray</code></strong></p>\n\n<p>Returns two numpy.ndarrays with dtype=numpy.float32 of grid latitudes and\nlongitudes in units of degrees.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.addlocal", "modulename": "grib2io", "qualname": "Grib2Message.addlocal", "type": "function", "doc": "<p>Add a Local Use Section <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_sect2.shtml\">(Section 2)</a>\nto the GRIB2 message.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>ludata : bytes</code></strong>: Local Use data.</p>\n", "signature": "(self, ludata)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.addgrid", "modulename": "grib2io", "qualname": "Grib2Message.addgrid", "type": "function", "doc": "<p>Add a Grid Definition Section <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_doc/grib2_sect3.shtml\">(Section 3)</a> \nto the GRIB2 message.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>gdsinfo</code></strong>: Sequence containing information needed for the grid definition section.</p>\n\n<table>\n<thead>\n<tr>\n  <th style=\"text-align:center;\">Index</th>\n  <th style=\"text-align:left;\">Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td style=\"text-align:center;\">gdsinfo[0]</td>\n  <td style=\"text-align:left;\">Source of grid definition - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table3-0.shtml\">Code Table 3.0</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">gdsinfo[1]</td>\n  <td style=\"text-align:left;\">Number of data points</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">gdsinfo[2]</td>\n  <td style=\"text-align:left;\">Number of octets for optional list of numbers defining number of points</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">gdsinfo[3]</td>\n  <td style=\"text-align:left;\">Interpetation of list of numbers defining number of points - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table3-11.shtml\">Code Table 3.11</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">gdsinfo[4]</td>\n  <td style=\"text-align:left;\">Grid Definition Template Number - <a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table3-1.shtml\">Code Table 3.1</a></td>\n</tr>\n</tbody>\n</table>\n\n<p><strong><code>gdtmpl</code></strong>: Sequence of values for the specified Grid Definition Template. Each \nelement of this integer array contains an entry (in the order specified) of Grid\nDefinition Template 3.NN</p>\n\n<p><strong><code>deflist</code></strong>: Sequence containing the number of grid points contained in each \nrow (or column) of a non-regular grid.  Used if gdsinfo[2] != 0.</p>\n", "signature": "(self, gdsinfo, gdtmpl, deflist=None)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.addfield", "modulename": "grib2io", "qualname": "Grib2Message.addfield", "type": "function", "doc": "<p>Add a Product Definition, Data Representation, Bitmap, and Data Sections \nto <code>Grib2Message</code> instance (i.e. Sections 4-7).  Must be called after the grid \ndefinition section has been added (<code>addfield</code>).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>field</code></strong>: Numpy array of data values to pack.  If field is a masked array, then \na bitmap is created from the mask.</p>\n\n<p><strong><code>pdtnum</code></strong>: integer Product Definition Template Number - <a href=\"http://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_table4-0.shtml\">Code Table 4.0</a></p>\n\n<p><strong><code>pdtmpl</code></strong>: Sequence with the data values for the specified Product Definition \nTemplate (N=pdtnum).  Each element of this integer array contains an entry (in \nthe order specified) of Product Definition Template 4.N.</p>\n\n<p><strong><code>coordlist</code></strong>: Sequence containing floating point values intended to document the \nvertical discretization with model data on hybrid coordinate vertical levels. Default is <code>None</code>.</p>\n\n<p><strong><code>packing</code></strong>: String to specify the type of packing. Valid options are the following:</p>\n\n<table>\n<thead>\n<tr>\n  <th style=\"text-align:center;\">Packing Scheme</th>\n  <th style=\"text-align:center;\">Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td style=\"text-align:center;\">'simple'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-0.shtml\">Simple packing</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'complex'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-2.shtml\">Complex packing</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'complex-spdiff'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-3.shtml\">Complex packing with Spatial Differencing</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'jpeg'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-40.shtml\">JPEG compression</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'png'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-41.shtml\">PNG compression</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'spectral-simple'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-50.shtml\">Spectral Data - Simple packing</a></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'spectral-complex'</td>\n  <td style=\"text-align:center;\"><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_temp5-51.shtml\">Spectral Data - Complex packing</a></td>\n</tr>\n</tbody>\n</table>\n\n<p><strong><code>**packing_opts</code></strong>: Packing keyword arguments. The keywords are the same as Grib2Message attribute names for\nthe Data Representation Template (Section 5) metadata. Valid keywords per packing scheme are the following:</p>\n\n<table>\n<thead>\n<tr>\n  <th style=\"text-align:center;\">Packing Scheme</th>\n  <th style=\"text-align:center;\">Keyword Arguments</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td style=\"text-align:center;\">'simple'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'complex'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code>, <code>priMissingValue</code>, [<code>secMissingValue</code>]</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'complex-spdiff'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code>, <code>spatialDifferenceOrder</code>, <code>priMissingValue</code>, [<code>secMissingValue</code>]</td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'jpeg'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'png'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'spectral-simple'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code></td>\n</tr>\n<tr>\n  <td style=\"text-align:center;\">'spectral-complex'</td>\n  <td style=\"text-align:center;\"><code>binScaleFactor</code>, <code>decScaleFactor</code></td>\n</tr>\n</tbody>\n</table>\n", "signature": "(\n    self,\n    field,\n    pdtnum,\n    pdtmpl,\n    coordlist=None,\n    packing='complex-spdiff',\n    **packing_opts\n)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.end", "modulename": "grib2io", "qualname": "Grib2Message.end", "type": "function", "doc": "<p>Add End Section (Section 8) to the GRIB2 message. A GRIB2 message \nis not complete without an end section.  Once an end section is added, \nthe GRIB2 message can be written to file.</p>\n", "signature": "(self)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Message.to_bytes", "modulename": "grib2io", "qualname": "Grib2Message.to_bytes", "type": "function", "doc": "<p>Return grib data in byte format. Useful for exporting data in non-file formats.\nFor example, can be used to output grib data directly to S3 using the boto3 client\nwithout the need to write a temporary file to upload first.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>validate</code></strong>: bool (Default: True) If true, validates first/last four bytes for proper formatting, else\nreturns None. If False, message is output as is.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>Returns GRIB2 formatted message as bytes.</p>\n", "signature": "(self, validate=True)", "funcdef": "def"}, {"fullname": "grib2io.Grib2Metadata", "modulename": "grib2io", "qualname": "Grib2Metadata", "type": "class", "doc": "<p>Class to hold GRIB2 metadata both as numeric code value as stored in\nGRIB2 and its plain langauge definition.</p>\n\n<p><strong><code>value : int</code></strong></p>\n\n<p>GRIB2 metadata integer code value.</p>\n\n<p><strong><code>table : str, optional</code></strong></p>\n\n<p>GRIB2 table to lookup the <code>value</code>. Default is None.</p>\n"}, {"fullname": "grib2io.Grib2Metadata.__init__", "modulename": "grib2io", "qualname": "Grib2Metadata.__init__", "type": "function", "doc": "<p></p>\n", "signature": "(self, value, table=None)", "funcdef": "def"}, {"fullname": "grib2io.show_config", "modulename": "grib2io", "qualname": "show_config", "type": "function", "doc": "<p>Print grib2io build configuration information.</p>\n", "signature": "()", "funcdef": "def"}, {"fullname": "grib2io.tables", "modulename": "grib2io.tables", "type": "module", "doc": "<p>Functions for retreiving data from NCEP GRIB2 Tables.</p>\n"}, {"fullname": "grib2io.tables.get_table", "modulename": "grib2io.tables", "qualname": "get_table", "type": "function", "doc": "<p>Return GRIB2 code table as a dictionary.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>table</code></strong>: Code table number (e.g. '1.0'). NOTE: Code table '4.1' requires a 3rd value \nrepresenting the product discipline (e.g. '4.1.0').</p>\n\n<p><strong><code>expand</code></strong>: If <code>True</code>, expand output dictionary where keys are a range.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>dict</code></strong></p>\n", "signature": "(table, expand=False)", "funcdef": "def"}, {"fullname": "grib2io.tables.get_value_from_table", "modulename": "grib2io.tables", "qualname": "get_value_from_table", "type": "function", "doc": "<p>Return the definition given a GRIB2 code table.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>value</code></strong>: <code>int</code> or <code>str</code> code table value.</p>\n\n<p><strong><code>table</code></strong>: <code>str</code> code table number.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>Table value or <code>None</code> if not found.</p>\n", "signature": "(value, table)", "funcdef": "def"}, {"fullname": "grib2io.tables.get_varinfo_from_table", "modulename": "grib2io.tables", "qualname": "get_varinfo_from_table", "type": "function", "doc": "<p>Return the GRIB2 variable information given values of <code>discipline</code>,\n<code>parmcat</code>, and <code>parmnum</code>. NOTE: This functions allows for all arguments\nto be converted to a string type if arguments are integer.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>discipline</code></strong>: <code>int</code> or <code>str</code> of Discipline code value of a GRIB2 message.</p>\n\n<p><strong><code>parmcat</code></strong>: <code>int</code> or <code>str</code> of Parameter Category value of a GRIB2 message.</p>\n\n<p><strong><code>parmnum</code></strong>: <code>int</code> or <code>str</code> of Parameter Number value of a GRIB2 message.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>list</code></strong>: containing variable information. \"Unknown\" is given for item of\ninformation if variable is not found.</p>\n\n<ul>\n<li>list[0] = full name</li>\n<li>list[1] = units</li>\n<li>list[2] = short name (abbreviated name)</li>\n</ul>\n", "signature": "(discipline, parmcat, parmnum)", "funcdef": "def"}, {"fullname": "grib2io.tables.get_wgrib2_level_string", "modulename": "grib2io.tables", "qualname": "get_wgrib2_level_string", "type": "function", "doc": "<p>Return a string that describes the level or layer of the GRIB2 message. The\nformat and language of the string is an exact replica of how wgrib2 produces\nthe level/layer string in its inventory output.</p>\n\n<p>Contents of wgrib2 source, <a href=\"https://github.com/NOAA-EMC/NCEPLIBS-wgrib2/blob/develop/wgrib2/Level.c\">Level.c</a>,\nwere converted into a Python dictionary and stored in grib2io as table\n'wgrib2_level_string'.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>type1</code></strong>: <code>int</code> type of first fixed surface.</p>\n\n<p><strong><code>sfac1</code></strong>: <code>int</code> scale factor of first fixed surface.</p>\n\n<p><strong><code>sval1</code></strong>: <code>int</code> scaled value of first fixed surface.</p>\n\n<p><strong><code>type2</code></strong>: <code>int</code> type of second fixed surface.</p>\n\n<p><strong><code>sfac2</code></strong>: <code>int</code> scale factor of second fixed surface.</p>\n\n<p><strong><code>sval2</code></strong>: <code>int</code> scaled value of second fixed surface.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>str</code></strong>: wgrib2-formatted level/layer string.</p>\n", "signature": "(type1, sfac1, sval1, type2, sfac2, sval2)", "funcdef": "def"}, {"fullname": "grib2io.tables.originating_centers", "modulename": "grib2io.tables.originating_centers", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section0", "modulename": "grib2io.tables.section0", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section1", "modulename": "grib2io.tables.section1", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section3", "modulename": "grib2io.tables.section3", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4", "modulename": "grib2io.tables.section4", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline0", "modulename": "grib2io.tables.section4_discipline0", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline1", "modulename": "grib2io.tables.section4_discipline1", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline10", "modulename": "grib2io.tables.section4_discipline10", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline2", "modulename": "grib2io.tables.section4_discipline2", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline3", "modulename": "grib2io.tables.section4_discipline3", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section4_discipline4", "modulename": "grib2io.tables.section4_discipline4", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.tables.section5", "modulename": "grib2io.tables.section5", "type": "module", "doc": "<p></p>\n"}, {"fullname": "grib2io.utils", "modulename": "grib2io.utils", "type": "module", "doc": "<p>Collection of utility functions to assist in the encoding and decoding\nof GRIB2 Messages.</p>\n"}, {"fullname": "grib2io.utils.int2bin", "modulename": "grib2io.utils", "qualname": "int2bin", "type": "function", "doc": "<p>Convert integer to binary string or list</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>i</code></strong>: Integer value to convert to binary representation.</p>\n\n<p><strong><code>nbits</code></strong>: Number of bits to return.  Valid values are 8 [DEFAULT], 16,\n32, and 64.</p>\n\n<p><strong><code>output</code></strong>: Return data as <code>str</code> [DEFAULT] or <code>list</code> (list of ints).</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><code>str</code> or <code>list</code> (list of ints) of binary representation of the integer value.</p>\n", "signature": "(i, nbits=8, output=<class 'str'>)", "funcdef": "def"}, {"fullname": "grib2io.utils.putieeeint", "modulename": "grib2io.utils", "qualname": "putieeeint", "type": "function", "doc": "<p>Convert an IEEE 32-bit float to a 32-bit integer.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>r</code></strong>: Float value.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>Integer representation of an IEEE 32-bit float.</p>\n", "signature": "(r)", "funcdef": "def"}, {"fullname": "grib2io.utils.getieeeint", "modulename": "grib2io.utils", "qualname": "getieeeint", "type": "function", "doc": "<p>Convert a 32-bit integer to an IEEE 32-bit float.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>i</code></strong>: Integer value.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>IEEE 32-bit float.</p>\n", "signature": "(i)", "funcdef": "def"}, {"fullname": "grib2io.utils.getmd5str", "modulename": "grib2io.utils", "qualname": "getmd5str", "type": "function", "doc": "<p>Generate a MD5 hash string from input list</p>\n", "signature": "(a)", "funcdef": "def"}, {"fullname": "grib2io.utils.getdate", "modulename": "grib2io.utils", "qualname": "getdate", "type": "function", "doc": "<p>Build an integer date from component input.</p>\n\n<p><strong><code>year</code></strong>: Year in 4-digit format.</p>\n\n<p><strong><code>month</code></strong>: Month in 2-digit format.</p>\n\n<p><strong><code>day</code></strong>: Day in 2-digit format.</p>\n\n<p><strong><code>hour</code></strong>: Hour in 2-digit format.</p>\n\n<p><strong><code>minute</code></strong>: Minute in 2-digit format. This argument is required if second is provided, otherwise\nit is optional.</p>\n\n<p><strong><code>second</code></strong>: Second in 2-digit format [OPTIONAL].</p>\n", "signature": "(year, month, day, hour, minute=None, second=None)", "funcdef": "def"}, {"fullname": "grib2io.utils.getleadtime", "modulename": "grib2io.utils", "qualname": "getleadtime", "type": "function", "doc": "<p>Computes the lead time (in units of hours) from using information from\nGRIB2 Identification Section (Section 1), Product Definition Template\nNumber, and Product Definition Template (Section 4).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>idsec</code></strong>: seqeunce containing GRIB2 Identification Section (Section 1).</p>\n\n<p><strong><code>pdtn</code></strong>: GRIB2 Product Definition Template Number</p>\n\n<p><strong><code>idsec</code></strong>: seqeunce containing GRIB2 Product Definition Template (Section 4).</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>lt</code></strong>: Lead time in units of hours</p>\n", "signature": "(idsec, pdtn, pdt)", "funcdef": "def"}, {"fullname": "grib2io.utils.getduration", "modulename": "grib2io.utils", "qualname": "getduration", "type": "function", "doc": "<p>Computes the duration time (in units of hours) from using information from\nProduct Definition Template Number, and Product Definition Template (Section 4).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>pdtn</code></strong>: GRIB2 Product Definition Template Number</p>\n\n<p><strong><code>pdt</code></strong>: sequence containing GRIB2 Product Definition Template (Section 4).</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>dur</code></strong>: Duration time in units of hours</p>\n", "signature": "(pdtn, pdt)", "funcdef": "def"}, {"fullname": "grib2io.utils.decode_mdl_wx_strings", "modulename": "grib2io.utils", "qualname": "decode_mdl_wx_strings", "type": "function", "doc": "<p>Decode GRIB2 Local Use Section to obtain MDL Weather Strings.  The\ndecode procedure is defined here:</p>\n\n<p><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_mdl_temp2-1.shtml\">https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_mdl_temp2-1.shtml</a></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>lus</code></strong>: GRIB2 Local Use Section containing MDL weather strings.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>list</code></strong>: List of weather strings.</p>\n", "signature": "(lus)", "funcdef": "def"}, {"fullname": "grib2io.utils.decode_ndfd_wx_strings", "modulename": "grib2io.utils", "qualname": "decode_ndfd_wx_strings", "type": "function", "doc": "<p>Decode GRIB2 Local Use Section to obtain NDFD Weather Strings.  The\ndecode procedure is defined here:</p>\n\n<p><a href=\"https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_mdl_temp2-1.shtml\">https://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc/grib2_mdl_temp2-1.shtml</a></p>\n\n<p>NOTE: From testing, it seems how the process for packing Section 2 for NDFD\n      Weather grids is different than GMOS and thus the need for a different\n      method for decoding NDFD Wx vs. GMOS Wx.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>lus</code></strong>: GRIB2 Local Use Section containing NDFD weather strings.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>list</code></strong>: List of NDFD weather strings.</p>\n", "signature": "(lus)", "funcdef": "def"}, {"fullname": "grib2io.utils.get_wgrib2_prob_string", "modulename": "grib2io.utils", "qualname": "get_wgrib2_prob_string", "type": "function", "doc": "<p>Return a wgrib2-formatted string explaining probabilistic\nthreshold informaiton.  Logic from wgrib2 source, <a href=\"https://github.com/NOAA-EMC/NCEPLIBS-wgrib2/blob/develop/wgrib2/Prob.c\">Prob.c</a>,\nis replicated here.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>probtype</code></strong>: <code>int</code> type of probability (Code Table 4.9).</p>\n\n<p><strong><code>sfacl</code></strong>: <code>int</code> scale factor of lower limit.</p>\n\n<p><strong><code>svall</code></strong>: <code>int</code> scaled value of lower limit.</p>\n\n<p><strong><code>sfacu</code></strong>: <code>int</code> scale factor of upper limit.</p>\n\n<p><strong><code>svalu</code></strong>: <code>int</code> scaled value of upper limit.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p><strong><code>str</code></strong>: wgrib2-formatted string of probability threshold.</p>\n", "signature": "(probtype, sfacl, svall, sfacu, svalu)", "funcdef": "def"}, {"fullname": "grib2io.utils.gauss_grid", "modulename": "grib2io.utils.gauss_grid", "type": "module", "doc": "<p>Tools for working with Gaussian grids.</p>\n"}, {"fullname": "grib2io.utils.gauss_grid.gaussian_latitudes", "modulename": "grib2io.utils.gauss_grid", "qualname": "gaussian_latitudes", "type": "function", "doc": "<p>Construct latitudes for a Gaussian grid.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p><strong><code>nlat</code></strong>: The number of latitudes in the Gaussian grid.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>Numpy array of latitudes (in degrees) with a length of <code>nlat</code>.</p>\n", "signature": "()", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();