<p align="center">
  <img src="https://raw.githubusercontent.com/puria/aglfn/master/assets/noun_dictionary_2407204.svg" width="100" height="100">
</p>

<h1 align="center">aglfn</h1>

<p align="center">
  <a href="https://travis-ci.org/puria/aglfn">
    <img src="https://travis-ci.org/puria/aglfn.svg?branch=master" alt="Build Status">
  </a>
  <a href="https://codecov.io/gh/puria/aglfn">
    <img src="https://codecov.io/gh/puria/aglfn/branch/master/graph/badge.svg" alt="Code coverage"/>
  </a>
  <a href="https://pypi.org/project/aglfn/">
    <img alt="PyPI release" src="https://img.shields.io/pypi/v/aglfn.svg" alt="Latest release">
  </a>
</p>

<div align="center"><sub>Python utilities for AGLFN (Adobe Glyph List For New Fonts) </sub></div>

<br><br>

<div align="center">
  <pre>pip install <a href="http://pypi.org/project/aglfn">aglfn</a></pre>
</div>

<br><br>


<h4 align="center">
  <a href="#-install">💾 Install</a>
  <span> • </span>
  <a href="#-quick-start">🎮 Quick start</a>
  <span> • </span>
  <a href="#-testing">📋 Testing</a>
  <span> • </span>
  <a href="#-acknowledgements">😍 Acknowledgements</a>
  <span> • </span>
  <a href="#-contributing">👤 Contributing</a>
  <span> • </span>
  <a href="#-license">💼 License</a>
</h4>

<br><br>

**aglfn** is a small utility to access [AGLFN](https://github.com/adobe-type-tools/agl-aglfn) names easily in Python.
Many software tools for new typefaces often referes to glyphs with this names.
Some typography tools tend to hardcode the aglfn.txt file and parse it, so this
is an attempt to have the submodule of the AGLFN repository without inglobe
those files each time in our repos.

AGFLN is a subset of the AGL list intended to provide a baselist of glyphs for a
new Latin font. More detailed information could be found on the 
[repo](https://github.com/adobe-type-tools/agl-aglfn) and on the 
[AGL specification](https://github.com/adobe-type-tools/agl-specification).

<br><br>

<details>
 <summary><strong>🚩 Table of Contents</strong> (click to expand)</summary>

* [Install](#-install)
* [Quick start](#-quick-start)
* [Testing](#-testing)
* [Acknowledgements](#-acknowledgements)
* [Contributing](#-contributing)
* [License](#-license)
</details>

***
## 💾 Install
```pip install aglfn```

or if you want to install it locally for development clone this repo and then

```bash
cd aglfn
pip install -e .
```

***
## 🎮 Quick start

### `names`
get the list of all the AGLFN names

```python
import aglfn

print(aglfn.names)
```

### `glyphs`
get the list of all glyphs with a corresponding AGLFN name
```python
import aglfn

print(aglfn.glyphs)
```

### `name()`
get the corresponding AGLFN name by passing a glyph
```python
import aglfn

name = aglfn.name('€')
assert 'Euro' == name
```

### `to_glyph()`
get the corresponding glyph by passing an AGLFN name
```python
import aglfn

glyph = aglfn.to_glyph('Euro')
assert '€' == glyph
```

***

## 📋 Testing

Test are executed with travis, in case you want to run them locally just:

```bash
cd aglfn
python setup.py test
```

***
## 😍 Acknowledgements

Copyright 🄯 2020 Puria Nafisi Azizi, Italy

Designed, written and maintained by Puria Nafisi Azizi.

Logo, dictionary by Smalllike from the Noun Project.


***
## 👤 Contributing

1.  🔀 [FORK IT](../../fork)
2.  Create your feature branch `git checkout -b feature/branch`
3.  Commit your changes `git commit -am 'Add some foobar'`
4.  Push to the branch `git push origin feature/branch`
5.  Create a new Pull Request
6.  🙏 Thank you


***
## 💼 License
    aglfn - Python utilities for Adobe Glyph List For New Fonts
    Copyright 🄯 2020 Puria Nafisi Azizi, Italy

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

