"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool", {
                deletionProtection: true,
                passwordPolicy: {
                    minLength: 8,
                    requireLowercase: true,
                    requireUppercase: true,
                    requireDigits: true,
                    requireSymbols: true,
                    tempPasswordValidity: aws_cdk_lib_1.Duration.days(3),
                },
                mfa: aws_cognito_1.Mfa.REQUIRED,
                accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
                autoVerify: {
                    email: true,
                },
            });
            this.userPool.node.defaultChild.userPoolAddOns = {
                advancedSecurityMode: "ENFORCED",
            };
            const stack = aws_cdk_lib_1.Stack.of(this);
            ["AwsSolutions-IAM5", "AwsPrototyping-IAMNoWildcardPermissions"].forEach((RuleId) => {
                pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                    {
                        id: RuleId,
                        reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                        appliesTo: ["Resource::*"],
                    },
                ]);
            });
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [
                            new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
                                userPool: this.userPool,
                                userPoolClient: this.userPoolClient,
                            }),
                        ]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.14.16" };
//# sourceMappingURL=data:application/json;base64,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