import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeManagedSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The unique identifier for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#certificate_id ComputeManagedSslCertificate#certificate_id}
     *
     * @stability stable
     */
    readonly certificateId?: number;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#description ComputeManagedSslCertificate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     *
     * These are in the same namespace as the managed SSL certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#name ComputeManagedSslCertificate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#project ComputeManagedSslCertificate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Enum field whose value is always 'MANAGED' - used to signal to the API which type this is.
     *
     * Default value: "MANAGED" Possible values: ["MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#type ComputeManagedSslCertificate#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * managed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#managed ComputeManagedSslCertificate#managed}
     *
     * @stability stable
     */
    readonly managed?: ComputeManagedSslCertificateManaged;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#timeouts ComputeManagedSslCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeManagedSslCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeManagedSslCertificateManaged {
    /**
     * Domains for which a managed SSL certificate will be valid.
     *
     * Currently,
     * there can be up to 100 domains in this list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#domains ComputeManagedSslCertificate#domains}
     *
     * @stability stable
     */
    readonly domains: string[];
}
export declare function computeManagedSslCertificateManagedToTerraform(struct?: ComputeManagedSslCertificateManagedOutputReference | ComputeManagedSslCertificateManaged): any;
/**
 * @stability stable
 */
export declare class ComputeManagedSslCertificateManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeManagedSslCertificateManaged | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeManagedSslCertificateManaged | undefined);
    private _domains?;
    /**
     * @stability stable
     */
    get domains(): string[];
    /**
     * @stability stable
     */
    set domains(value: string[]);
    /**
     * @stability stable
     */
    get domainsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeManagedSslCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#create ComputeManagedSslCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#delete ComputeManagedSslCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeManagedSslCertificateTimeoutsToTerraform(struct?: ComputeManagedSslCertificateTimeoutsOutputReference | ComputeManagedSslCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeManagedSslCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeManagedSslCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeManagedSslCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html google_compute_managed_ssl_certificate}.
 *
 * @stability stable
 */
export declare class ComputeManagedSslCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html google_compute_managed_ssl_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: ComputeManagedSslCertificateConfig);
    private _certificateId?;
    /**
     * @stability stable
     */
    get certificateId(): number;
    /**
     * @stability stable
     */
    set certificateId(value: number);
    /**
     * @stability stable
     */
    resetCertificateId(): void;
    /**
     * @stability stable
     */
    get certificateIdInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get subjectAlternativeNames(): string[];
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _managed;
    /**
     * @stability stable
     */
    get managed(): ComputeManagedSslCertificateManagedOutputReference;
    /**
     * @stability stable
     */
    putManaged(value: ComputeManagedSslCertificateManaged): void;
    /**
     * @stability stable
     */
    resetManaged(): void;
    /**
     * @stability stable
     */
    get managedInput(): ComputeManagedSslCertificateManaged | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeManagedSslCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeManagedSslCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeManagedSslCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
