# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_wandb_utils.ipynb (unless otherwise specified).

__all__ = ['log_df_as_tables', 'log_to_artifacts']

# Cell
import os
import wandb
import pandas as pd

# Cell
def log_df_as_tables(
    df,  # Dataframe to be logged
    table_name:str="my_table"  # Name to give the W&B Table
):
    "Logs a dataframe as a W&B Table to W&B, `wandb.init()` must be called before using this function."

    # create W&B tables object
    tables = wandb.Table(dataframe=df)
    wandb.log({f"{table_name}": tables})

# Cell
def log_to_artifacts(
    path_to_data, # Path to file or directory to be logged
    artifact_name,  # Name of the W&B Artifact
    artifact_type:str='dataset',  # Type of artifact, defined by user, e.g. "model", "raw-dataset" etc (default: dataset)
    log:str='file'  # Type of data being logged, can be "file" or "dir"
):
    "Logs a file or directory as an artifact, `wandb.init()` must be called before using this function."

    artifact = wandb.Artifact(artifact_name, type=artifact_type)

    if log == 'file':
        artifact.add_file(path_to_data)
    elif log == 'dir':
        artifact.add_dir(path_to_data)

    wandb.log_artifact(artifact)