# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta,ConstEnumMeta
    class CharSet(metaclass=UnoConstMeta, type_name="com.sun.star.awt.CharSet", name_space="com.sun.star.awt"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.awt.CharSet``"""
        pass

    class CharSetEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.awt.CharSet", name_space="com.sun.star.awt"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.awt.CharSet`` as Enum values"""
        pass

else:
    from ...lo.awt.char_set import CharSet as CharSet

    class CharSetEnum(IntEnum):
        """
        Enum of Const Class CharSet

        These values are used to specify the characters which are available in a font and their codes.
        
        The currently defined constants of CharSet have the same numerical values as the corresponding enum values of the C/C++ rtl_TextEncoding (from rtl/textenc.h). This correspondence is by design. Since CharSet is deprecated, however, it is not planned to add further constants to keep it in sync with rtl_TextEncoding.
        
        .. deprecated::
        
            Class is deprecated.
        """
        DONTKNOW = CharSet.DONTKNOW
        """
        specifies an unknown character set.
        """
        ANSI = CharSet.ANSI
        """
        specifies the ANSI character set.
        """
        MAC = CharSet.MAC
        """
        specifies the Apple Macintosh character set.
        """
        IBMPC_437 = CharSet.IBMPC_437
        """
        specifies the IBM PC character set number 437.
        """
        IBMPC_850 = CharSet.IBMPC_850
        """
        specifies the IBM PC character set number 850.
        """
        IBMPC_860 = CharSet.IBMPC_860
        """
        specifies the IBM PC character set number 860.
        """
        IBMPC_861 = CharSet.IBMPC_861
        """
        specifies the IBM PC character set number 861.
        """
        IBMPC_863 = CharSet.IBMPC_863
        """
        specifies the IBM PC character set number 863.
        """
        IBMPC_865 = CharSet.IBMPC_865
        """
        specifies the IBM PC character set number 865.
        """
        SYSTEM = CharSet.SYSTEM
        """
        specifies the system character set.
        """
        SYMBOL = CharSet.SYMBOL
        """
        specifies a set of symbols.
        """

__all__ = ['CharSet', 'CharSetEnum']
