# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta,ConstEnumMeta
    class TextConversionType(metaclass=UnoConstMeta, type_name="com.sun.star.i18n.TextConversionType", name_space="com.sun.star.i18n"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.i18n.TextConversionType``"""
        pass

    class TextConversionTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.i18n.TextConversionType", name_space="com.sun.star.i18n"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.i18n.TextConversionType`` as Enum values"""
        pass

else:
    from ...lo.i18n.text_conversion_type import TextConversionType as TextConversionType

    class TextConversionTypeEnum(IntEnum):
        """
        Enum of Const Class TextConversionType

        These constants specify the conversion type to be used with XTextConversion.
        
        **since**
        
            OOo 1.1.2
        """
        TO_HANGUL = TextConversionType.TO_HANGUL
        """
        Conversion from Hanja to Hangul.
        """
        TO_HANJA = TextConversionType.TO_HANJA
        """
        Conversion from Hangul to Hanja.
        """
        TO_SCHINESE = TextConversionType.TO_SCHINESE
        """
        Conversion from Traditional to Simplified Chinese.
        """
        TO_TCHINESE = TextConversionType.TO_TCHINESE
        """
        Conversion from Simplified to Traditional Chinese.
        """

__all__ = ['TextConversionType', 'TextConversionTypeEnum']
