# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.inspection
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta,ConstEnumMeta
    class PropertyLineElement(metaclass=UnoConstMeta, type_name="com.sun.star.inspection.PropertyLineElement", name_space="com.sun.star.inspection"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.inspection.PropertyLineElement``"""
        pass

    class PropertyLineElementEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.inspection.PropertyLineElement", name_space="com.sun.star.inspection"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.inspection.PropertyLineElement`` as Enum values"""
        pass

else:
    from ...lo.inspection.property_line_element import PropertyLineElement as PropertyLineElement

    class PropertyLineElementEnum(IntEnum):
        """
        Enum of Const Class PropertyLineElement

        describes elements of a single line in an object inspector, used to represent a single property
        
        **since**
        
            OOo 2.0.3
        """
        InputControl = PropertyLineElement.InputControl
        """
        specifies the input control in a group of controls related to a single property
        """
        PrimaryButton = PropertyLineElement.PrimaryButton
        """
        specifies the primary button (if present) in a group of controls related to a single property
        """
        SecondaryButton = PropertyLineElement.SecondaryButton
        """
        specifies the secondary button (if present) in a group of controls related to a single property
        """
        All = PropertyLineElement.All
        """
        specifies all elements
        """

__all__ = ['PropertyLineElement', 'PropertyLineElementEnum']
