# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.rendering
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta,ConstEnumMeta
    class FloatingPointBitmapFormat(metaclass=UnoConstMeta, type_name="com.sun.star.rendering.FloatingPointBitmapFormat", name_space="com.sun.star.rendering"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.rendering.FloatingPointBitmapFormat``"""
        pass

    class FloatingPointBitmapFormatEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.rendering.FloatingPointBitmapFormat", name_space="com.sun.star.rendering"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.rendering.FloatingPointBitmapFormat`` as Enum values"""
        pass

else:
    from ...lo.rendering.floating_point_bitmap_format import FloatingPointBitmapFormat as FloatingPointBitmapFormat

    class FloatingPointBitmapFormatEnum(IntEnum):
        """
        Enum of Const Class FloatingPointBitmapFormat

        This structure describes format of a floating point bitmap.
        
        **since**
        
            OOo 2.0
        """
        HALFFLOAT = FloatingPointBitmapFormat.HALFFLOAT
        """
        Half-float format.
        
        The color components are stored in the half-float format, i.e. in a 16 bit value, with 5 bit exponent, 10 bit mantissa and a sign bit. See also OpenEXR for a format employing half-floats.
        """
        FLOAT = FloatingPointBitmapFormat.FLOAT
        """
        IEEE float format.
        
        The color components are stored in the IEEE single-precision floating point format, i.e. in a 32 bit value, with 8 bit exponent, 23 bit mantissa and a sign bit.
        """
        DOUBLE = FloatingPointBitmapFormat.DOUBLE
        """
        IEEE double format.
        
        The color components are stored in the IEEE double-precision floating point format, i.e. in a 64 bit value, with 16 bit exponent, 47 bit mantissa and a sign bit.
        """

__all__ = ['FloatingPointBitmapFormat', 'FloatingPointBitmapFormatEnum']
