# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.text
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta,ConstEnumMeta
    class WritingMode2(metaclass=UnoConstMeta, type_name="com.sun.star.text.WritingMode2", name_space="com.sun.star.text"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.text.WritingMode2``"""
        pass

    class WritingMode2Enum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.text.WritingMode2", name_space="com.sun.star.text"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.text.WritingMode2`` as Enum values"""
        pass

else:
    from ...lo.text.writing_mode2 import WritingMode2 as WritingMode2

    class WritingMode2Enum(IntEnum):
        """
        Enum of Const Class WritingMode2

        this set of constants describes different writing directions
        
        In addition to numerous explicit writing directions, it allows to specify to take the writing direction from the object's context.
        
        **since**
        
            LibreOffice 6.3
        """
        LR_TB = WritingMode2.LR_TB
        """
        text within lines is written left-to-right.
        
        Lines and blocks are placed top-to-bottom.
        
        Typically, this is the writing mode for normal \"alphabetic\" text.
        """
        RL_TB = WritingMode2.RL_TB
        """
        text within a line are written right-to-left.
        
        Lines and blocks are placed top-to-bottom.
        
        Typically, this writing mode is used in Arabic and Hebrew text.
        """
        TB_RL = WritingMode2.TB_RL
        """
        text within a line is written top-to-bottom.
        
        Lines and blocks are placed right-to-left.
        
        Typically, this writing mode is used in Chinese and Japanese text.
        """
        TB_LR = WritingMode2.TB_LR
        """
        text within a line is written top-to-bottom.
        
        Lines and blocks are placed left-to-right.
        
        Typically, this writing mode is used in Mongolian text.
        """
        PAGE = WritingMode2.PAGE
        """
        obtain writing mode from the current page.
        
        May not be used in page styles.
        """
        CONTEXT = WritingMode2.CONTEXT
        """
        obtain actual writing mode from the context of the object.
        """
        BT_LR = WritingMode2.BT_LR
        """
        text within a line is written bottom-to-top.
        
        Lines and blocks are placed left-to-right.
        
        **since**
        
            LibreOffice 6.3
        """

__all__ = ['WritingMode2', 'WritingMode2Enum']
