# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class Point(object):
    """
    Struct Class

    specifies a 2-dimensional point using the Cartesian coordinate system.

    See Also:
        `API Point <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1Point.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.Point'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.Point'
    """Literal Constant ``com.sun.star.awt.Point``"""

    def __init__(self, X: typing.Optional[int] = 0, Y: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            X (int, optional): X value.
            Y (int, optional): Y value.
        """
        super().__init__()

        if isinstance(X, Point):
            oth: Point = X
            self.X = oth.X
            self.Y = oth.Y
            return

        kargs = {
            "X": X,
            "Y": Y,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._x = kwargs["X"]
        self._y = kwargs["Y"]


    @property
    def X(self) -> int:
        """
        specifies the x-coordinate.
        """
        return self._x
    
    @X.setter
    def X(self, value: int) -> None:
        self._x = value

    @property
    def Y(self) -> int:
        """
        specifies the y-coordinate.
        """
        return self._y
    
    @Y.setter
    def Y(self, value: int) -> None:
        self._y = value


__all__ = ['Point']
