# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_tab_listener import XTabListener as XTabListener_a36e0b09
    from ..beans.named_value import NamedValue as NamedValue_a37a0af3

class XSimpleTabController(XInterface_8f010a43):
    """
    specifies the basic operations for a tab controller, but does not require XControl as type of tabs.

    See Also:
        `API XSimpleTabController <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1awt_1_1XSimpleTabController.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.XSimpleTabController'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.awt.XSimpleTabController'

    @abstractmethod
    def activateTab(self, ID: int) -> None:
        """
        activate the specified tab.
        
        The new tab will be activated and all listener will get an event describing this. Of course there will be an event too, which notifies listener about the deactivation of the last active tab.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def addTabListener(self, Listener: 'XTabListener_a36e0b09') -> None:
        """
        register listener for inserting/removing tabs and changing their properties.
        """
        ...
    @abstractmethod
    def getActiveTabID(self) -> int:
        """
        return the unique ID of the current active tab.
        """
        ...
    @abstractmethod
    def getTabProps(self, ID: int) -> 'typing.Tuple[NamedValue_a37a0af3, ...]':
        """
        retrieve the set of properties for the specified tab.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def insertTab(self) -> int:
        """
        create a new tab and return a unique ID, which can be used further to address this tab by using other methods of this interface.
        """
        ...
    @abstractmethod
    def removeTab(self, ID: int) -> None:
        """
        remove a tab with the given ID.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def removeTabListener(self, Listener: 'XTabListener_a36e0b09') -> None:
        """
        unregister listener for inserting/removing tabs and changing their properties.
        """
        ...
    @abstractmethod
    def setTabProps(self, ID: int, Properties: 'typing.Tuple[NamedValue_a37a0af3, ...]') -> None:
        """
        change some properties of the specified tab.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...

__all__ = ['XSimpleTabController']

