# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.deployment
from abc import abstractmethod, ABC

class XPackageTypeInfo(ABC):
    """
    Objects of this interface provide information about a package's type.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XPackageTypeInfo <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1deployment_1_1XPackageTypeInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.deployment'
    __ooo_full_ns__: str = 'com.sun.star.deployment.XPackageTypeInfo'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.deployment.XPackageTypeInfo'

    @abstractmethod
    def getDescription(self) -> str:
        """
        returns a description string to describe a package type.

        Raises:
            ExtensionRemovedException: ``ExtensionRemovedException``
        """
        ...
    @abstractmethod
    def getFileFilter(self) -> str:
        """
        returns a file filter string for the file picker user interface.
        
        Both, the short description string and file filter string will be passed to com.sun.star.ui.dialogs.XFilterManager.appendFilter().
        """
        ...
    @abstractmethod
    def getIcon(self, highContrast: bool, smallIcon: bool) -> object:
        """
        returns an icon for a package.
        """
        ...
    @abstractmethod
    def getMediaType(self) -> str:
        """
        returns the media type of a package, e.g.
        
        application/vnd.sun.star.basic-script.
        """
        ...
    @abstractmethod
    def getShortDescription(self) -> str:
        """
        returns a short description string to describe a package type (one line only).

        Raises:
            ExtensionRemovedException: ``ExtensionRemovedException``
        """
        ...

__all__ = ['XPackageTypeInfo']

