# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.document
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..embed.x_storage import XStorage as XStorage_8e460a32
    from ..util.revision_tag import RevisionTag as RevisionTag_a6770b31

class XDocumentRevisionListPersistence(XInterface_8f010a43):
    """
    interface to load or store a list of document revisions from or to a document using the packed XML file format

    See Also:
        `API XDocumentRevisionListPersistence <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1document_1_1XDocumentRevisionListPersistence.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.document'
    __ooo_full_ns__: str = 'com.sun.star.document.XDocumentRevisionListPersistence'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.document.XDocumentRevisionListPersistence'

    @abstractmethod
    def load(self, Storage: 'XStorage_8e460a32') -> 'typing.Tuple[RevisionTag_a6770b31, ...]':
        """
        Loads a list of available revisions from a storage.
        
        This method does not load any revision itself

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
            com.sun.star.io.IOException: ``IOException``
            com.sun.star.uno.Exception: ``Exception``
        """
        ...
    @abstractmethod
    def store(self, Storage: 'XStorage_8e460a32', List: 'typing.Tuple[RevisionTag_a6770b31, ...]') -> None:
        """
        Stores a list of available revisions to a storage.
        
        This method does not store revisions themselves

        Raises:
            com.sun.star.io.IOException: ``IOException``
            com.sun.star.uno.Exception: ``Exception``
        """
        ...

__all__ = ['XDocumentRevisionListPersistence']

