# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.drawing


class QRCodeErrorCorrection(object):
    """
    Const Class

    These constants identify the type of Error Correction for a QR Code.
    
    The Error Correction for a QR code is a measure that helps a QR code to recover, if it is destroyed.
    
    Level L (Low) 7% of codewords can be restored. Level M (Medium) 15% of codewords can be restored. Level Q (Quartile) 25% of codewords can be restored. Level H (High) 30% of codewords can be restored.
    
    More Info - here
    
    **since**
    
        LibreOffice 6.4

    See Also:
        `API QRCodeErrorCorrection <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1drawing_1_1QRCodeErrorCorrection.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.drawing'
    __ooo_full_ns__: str = 'com.sun.star.drawing.QRCodeErrorCorrection'
    __ooo_type_name__: str = 'const'

    LOW = 1
    MEDIUM = 2
    QUARTILE = 3
    HIGH = 4

__all__ = ['QRCodeErrorCorrection']
