# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.embed
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..io.x_output_stream import XOutputStream as XOutputStream_a4e00b35

class XPackageStructureCreator(XInterface_8f010a43):
    """
    allows to convert filesystem folder tree into a package.

    See Also:
        `API XPackageStructureCreator <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1embed_1_1XPackageStructureCreator.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.embed'
    __ooo_full_ns__: str = 'com.sun.star.embed.XPackageStructureCreator'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.embed.XPackageStructureCreator'

    @abstractmethod
    def convertToPackage(self, sFolderURL: str, xTargetStream: 'XOutputStream_a4e00b35') -> None:
        """
        converts filesystem folder tree into a package.

        Raises:
            com.sun.star.io.IOException: ``IOException``
        """
        ...

__all__ = ['XPackageStructureCreator']

