# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.frame
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..awt.rectangle import Rectangle as Rectangle_84b109e9
    from .border_widths import BorderWidths as BorderWidths_bb920be4
    from .x_border_resize_listener import XBorderResizeListener as XBorderResizeListener_37520f81

class XControllerBorder(XInterface_8f010a43):
    """
    allows to retrieve information about controller's border.

    See Also:
        `API XControllerBorder <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1frame_1_1XControllerBorder.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame'
    __ooo_full_ns__: str = 'com.sun.star.frame.XControllerBorder'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.frame.XControllerBorder'

    @abstractmethod
    def addBorderResizeListener(self, xListener: 'XBorderResizeListener_37520f81') -> None:
        """
        adds the specified listener to receive events about controller's border resizing.
        """
        ...
    @abstractmethod
    def getBorder(self) -> 'BorderWidths_bb920be4':
        """
        allows to get current border sizes of the document.
        """
        ...
    @abstractmethod
    def queryBorderedArea(self, aPreliminaryRectangle: 'Rectangle_84b109e9') -> 'Rectangle_84b109e9':
        """
        allows to get suggestion for resizing of object area surrounded by the border.
        
        If the view is going to be resized/moved this method can be used to get suggested object area. Pixels are used as units.
        """
        ...
    @abstractmethod
    def removeBorderResizeListener(self, xListener: 'XBorderResizeListener_37520f81') -> None:
        """
        removes the specified listener.
        """
        ...

__all__ = ['XControllerBorder']

