# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.frame
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XUntitledNumbers(XInterface_8f010a43):
    """
    knows all currently used and all free numbers for using with untitled but counted objects.

    See Also:
        `API XUntitledNumbers <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1frame_1_1XUntitledNumbers.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame'
    __ooo_full_ns__: str = 'com.sun.star.frame.XUntitledNumbers'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.frame.XUntitledNumbers'

    @abstractmethod
    def getUntitledPrefix(self) -> str:
        """
        returns the localized string value to be used for untitled objects in combination with the leased number.
        
        Note: Such string already contains leading spaces/tabs etc. ! The only thing which an outside code has todo then ... adding a leased number to the string.
        """
        ...
    @abstractmethod
    def leaseNumber(self, xComponent: 'XInterface_8f010a43') -> int:
        """
        callee has to lease a number before he can use it within in its own title.
        
        Such number must be freed after using e.g. while the object was closed or gets another title (e.g. by saving a document to a real location on disc).

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def releaseNumber(self, nNumber: int) -> None:
        """
        has to be used to mark those numbers as \"free for using\".
        
        If the registered component does not use such leased number any longer it has to be released so it can be used for new components.
        
        Note: calling this method with an unknown (but normally valid number) has to be ignored. No exceptions - no errors.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def releaseNumberForComponent(self, xComponent: 'XInterface_8f010a43') -> None:
        """
        does the same then releaseNumber () but it searches the corresponding number for the specified component and deregister it.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...

__all__ = ['XUntitledNumbers']

