# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.i18n


class CalendarDisplayCode(object):
    """
    Const Class

    Constants to use with XExtendedCalendar.getDisplayString().
    
    The examples given are for an English Gregorian calendar, note that other calendars or locales may return completely different strings, for example not a four digit year but a CJK name instead.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API CalendarDisplayCode <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1i18n_1_1CalendarDisplayCode.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.CalendarDisplayCode'
    __ooo_type_name__: str = 'const'

    SHORT_DAY = 1
    """
    Day of month, one or two digits, no leading zero.
    """
    LONG_DAY = 2
    """
    Day of month, two digits, with leading zero.
    """
    SHORT_DAY_NAME = 3
    """
    Day of week, abbreviated name.
    """
    LONG_DAY_NAME = 4
    """
    Day of week, full name.
    """
    SHORT_MONTH = 5
    """
    Month of year, one or two digits, no leading zero.
    """
    LONG_MONTH = 6
    """
    Month of year, with leading zero.
    """
    SHORT_MONTH_NAME = 7
    """
    Abbreviated month name.
    """
    LONG_MONTH_NAME = 8
    """
    Full month name.
    """
    SHORT_YEAR = 9
    """
    Year, two digits.
    """
    LONG_YEAR = 10
    """
    Year, four digits.
    """
    SHORT_ERA = 11
    """
    Abbreviated era name, for example, BC or AD.
    """
    LONG_ERA = 12
    """
    Full era name, for example, \"Before Christ\" or \"Anno Dominus\".
    """
    SHORT_YEAR_AND_ERA = 13
    """
    Combined short year and era, order depends on locale/calendar.
    """
    LONG_YEAR_AND_ERA = 14
    """
    Combined full year and era, order depends on locale/calendar.
    """
    SHORT_QUARTER = 15
    """
    Short quarter, for example, \"Q1\".
    """
    LONG_QUARTER = 16
    """
    Long quarter, for example, \"1st quarter\".
    """
    SHORT_GENITIVE_MONTH_NAME = 17
    """
    Abbreviated possessive genitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    LONG_GENITIVE_MONTH_NAME = 18
    """
    Full possessive genitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    NARROW_GENITIVE_MONTH_NAME = 19
    """
    Narrow possessive genitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    SHORT_PARTITIVE_MONTH_NAME = 20
    """
    Abbreviated partitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    LONG_PARTITIVE_MONTH_NAME = 21
    """
    Full partitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    NARROW_PARTITIVE_MONTH_NAME = 22
    """
    Narrow partitive case month name.
    
    **since**
    
        LibreOffice 3.5
    """
    NARROW_DAY_NAME = 23
    """
    Day of week, narrow name.
    
    **since**
    
        LibreOffice 3.5
    """
    NARROW_MONTH_NAME = 24
    """
    Narrow month name.
    
    **since**
    
        LibreOffice 3.5
    """

__all__ = ['CalendarDisplayCode']
