# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.linguistic2
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .dictionary_event import DictionaryEvent as DictionaryEvent_3ae00f8d


class DictionaryListEvent(EventObject_a3d70b03):
    """
    Struct Class

    structure representing a dictionary-list event.
    
    This structure is used by the dictionary-list to inform its listeners about certain events. Since the dictionary-list is able to collect several single events before broadcasting them to its listeners the integer argument may be a combination (logical or) of several event types. If more specific information about the events is requested by a listener, a sequence of all dictionary-list events since the last broadcasting will be supplied. Otherwise, that list will be empty.

    See Also:
        `API DictionaryListEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1linguistic2_1_1DictionaryListEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.linguistic2'
    __ooo_full_ns__: str = 'com.sun.star.linguistic2.DictionaryListEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.linguistic2.DictionaryListEvent'
    """Literal Constant ``com.sun.star.linguistic2.DictionaryListEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, aDictionaryEvents: typing.Optional[typing.Tuple[DictionaryEvent_3ae00f8d, ...]] = (), nCondensedEvent: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            aDictionaryEvents (typing.Tuple[DictionaryEvent, ...], optional): aDictionaryEvents value.
            nCondensedEvent (int, optional): nCondensedEvent value.
        """

        if isinstance(Source, DictionaryListEvent):
            oth: DictionaryListEvent = Source
            self.Source = oth.Source
            self.aDictionaryEvents = oth.aDictionaryEvents
            self.nCondensedEvent = oth.nCondensedEvent
            return

        kargs = {
            "Source": Source,
            "aDictionaryEvents": aDictionaryEvents,
            "nCondensedEvent": nCondensedEvent,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._a_dictionary_events = kwargs["aDictionaryEvents"]
        self._n_condensed_event = kwargs["nCondensedEvent"]
        inst_keys = ('aDictionaryEvents', 'nCondensedEvent')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def aDictionaryEvents(self) -> typing.Tuple[DictionaryEvent_3ae00f8d, ...]:
        """
        list of accumulated dictionary events.
        
        It will be empty if all com.sun.star.linguistic2.XDictionaryListEventListener are satisfied with the condensed representation of the com.sun.star.linguistic2.DictionaryListEvent.nCondensedEvent().
        """
        return self._a_dictionary_events
    
    @aDictionaryEvents.setter
    def aDictionaryEvents(self, value: typing.Tuple[DictionaryEvent_3ae00f8d, ...]) -> None:
        self._a_dictionary_events = value

    @property
    def nCondensedEvent(self) -> int:
        """
        the combined type of the accumulated events.
        
        The value can be the combination of multiple com.sun.star.linguistic2.DictionaryListEventFlags by applying the logical OR to them.
        """
        return self._n_condensed_event
    
    @nCondensedEvent.setter
    def nCondensedEvent(self, value: int) -> None:
        self._n_condensed_event = value


__all__ = ['DictionaryListEvent']
