# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.linguistic2
import typing
from abc import abstractmethod
from .x_supported_locales import XSupportedLocales as XSupportedLocales_5bda1056
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ..lang.locale import Locale as Locale_70d308fa
    from .proofreading_result import ProofreadingResult as ProofreadingResult_6cc910d4

class XProofreader(XSupportedLocales_5bda1056):
    """
    API for proofreading a text.
    
    **since**
    
        OOo 3.0.1

    See Also:
        `API XProofreader <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1linguistic2_1_1XProofreader.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.linguistic2'
    __ooo_full_ns__: str = 'com.sun.star.linguistic2.XProofreader'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.linguistic2.XProofreader'

    @abstractmethod
    def doProofreading(self, aDocumentIdentifier: str, aText: str, aLocale: 'Locale_70d308fa', nStartOfSentencePosition: int, nSuggestedBehindEndOfSentencePosition: int, aProperties: 'typing.Tuple[PropertyValue_c9610c73, ...]') -> 'ProofreadingResult_6cc910d4':
        """
        start checking
        
        Currently the following properties may be supported:

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def ignoreRule(self, aRuleIdentifier: str, aLocale: 'Locale_70d308fa') -> None:
        """
        disables a specific rule for a given locale.
        
        If the locale is empty the rule should be ignored for all languages.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def isSpellChecker(self) -> bool:
        """
        whether is the text checked by the spell checker
        """
        ...
    @abstractmethod
    def resetIgnoreRules(self) -> None:
        """
        sets all rules back to their default settings.
        """
        ...

__all__ = ['XProofreader']

