# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.rendering
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XBufferController(XInterface_8f010a43):
    """
    Interface providing access to double/multi-buffer facilities of screen devices.
    
    This interface provides methods to enable and control double/multi-buffering facilities on screen devices.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XBufferController <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1rendering_1_1XBufferController.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.XBufferController'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.rendering.XBufferController'

    @abstractmethod
    def createBuffers(self, nBuffers: int) -> int:
        """
        Create the given number of background buffers.
        
        There's one buffer implicitly available, which is the canvas surface itself. Thus, calling createBuffers(1) creates a double-buffered object.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def destroyBuffers(self) -> None:
        """
        Destroy all buffers generated via this object.
        """
        ...
    @abstractmethod
    def showBuffer(self, bUpdateAll: bool) -> bool:
        """
        Switch the display to show the specified buffer.
        
        The method returns, when the switch is performed and the selected buffer is shown on screen, or immediately when an error occurs. If the switch was successful, subsequent render operations will be directed to the new backbuffer.
        
        Use this method if you need your screen display to be in sync with other things, e.g. sound playback.
        """
        ...
    @abstractmethod
    def switchBuffer(self, bUpdateAll: bool) -> bool:
        """
        Schedule the display of the specified buffer.
        
        The method returns, when the switching of the buffer is successfully scheduled, or immediately when an error occurs. If the switch was successful, subsequent render operations will be directed to the new backbuffer. Note that, if the buffer switching is exceedingly slow, or the frequency of switchBuffer() is exceedingly high, the buffer scheduled for display here might become the current render target before it is fully displayed on screen. In this case, any rendering operation to this buffer will block, until it is safe to perform the operation without visible cluttering.
        
        Use this method if you favor maximal render speed, but don't necessarily require your screen display to be in sync with other things, e.g. sound playback.
        """
        ...

__all__ = ['XBufferController']

