# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.rendering
import typing
import uno
from abc import abstractmethod
from .x_integer_read_only_bitmap import XIntegerReadOnlyBitmap as XIntegerReadOnlyBitmap_8cc01167
if typing.TYPE_CHECKING:
    from ..geometry.integer_point2_d import IntegerPoint2D as IntegerPoint2D_8f0dc2
    from ..geometry.integer_rectangle2_d import IntegerRectangle2D as IntegerRectangle2D_3c5c0f4d
    from .integer_bitmap_layout import IntegerBitmapLayout as IntegerBitmapLayout_5b94106f

class XIntegerBitmap(XIntegerReadOnlyBitmap_8cc01167):
    """
    This is a specialized interface for bitmaps having integer color channels.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XIntegerBitmap <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1rendering_1_1XIntegerBitmap.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.XIntegerBitmap'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.rendering.XIntegerBitmap'

    @abstractmethod
    def setData(self, data: uno.ByteSequence, bitmapLayout: 'IntegerBitmapLayout_5b94106f', rect: 'IntegerRectangle2D_3c5c0f4d') -> None:
        """
        Set raw data of a bitmap.
        
        Set raw data of a bitmap, in the format as defined by getMemoryLayout(). With the given rectangle, a subset of the bitmap can be changed. If the internal data format's pixel are not integer multiples of bytes (i.e. if one pixel occupies less than a byte), the leftover content of the bytes at the right of each scanline is ignored and left unchanged in the bitmap. When setting subsets of the bitmap, the same scanline padding takes place as when the whole bitmap is changed.
        
        When setting data on volatile bitmaps, always call isValid() before, and retrieve a new memory layout via getMemoryLayout(). At least under Windows, the memory layout can change for the same bitmap, if the user e.g. switches the screen resolution. Thus, this method will throw an IllegalArgumentException, if the memory layout changed between a call to getMemoryLayout() and setData().

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def setPixel(self, color: uno.ByteSequence, bitmapLayout: 'IntegerBitmapLayout_5b94106f', pos: 'IntegerPoint2D_8f0dc2') -> None:
        """
        Set a single pixel of the bitmap with the given color value.
        
        If the internal data format's pixel are not integer multiples of bytes (i.e. if one pixel occupies less than a byte), the color value is expected in the least significant bits of the single byte given as the color.
        
        When setting data on volatile bitmaps, always call isValid() before, and retrieve a new memory layout via getMemoryLayout(). At least under Windows, the memory layout can change for the same bitmap, if the user e.g. switches the screen resolution. Thus, this method will throw an IllegalArgumentException, if the memory layout changed between a call to getMemoryLayout() and setPixel().

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...

__all__ = ['XIntegerBitmap']

