# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.rendering
import typing
from abc import abstractmethod
from .x_poly_polygon2_d import XPolyPolygon2D as XPolyPolygon2D_e1b0e20
if typing.TYPE_CHECKING:
    from ..geometry.real_point2_d import RealPoint2D as RealPoint2D_d6e70c78

class XLinePolyPolygon2D(XPolyPolygon2D_e1b0e20):
    """
    Specialized interface for a 2D poly-polygon containing only straight line segments.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XLinePolyPolygon2D <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1rendering_1_1XLinePolyPolygon2D.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.XLinePolyPolygon2D'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.rendering.XLinePolyPolygon2D'

    @abstractmethod
    def getPoint(self, nPolygonIndex: int, nPointIndex: int) -> 'RealPoint2D_d6e70c78':
        """
        Get a single point from the poly-polygon.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def getPoints(self, nPolygonIndex: int, nNumberOfPolygons: int, nPointIndex: int, nNumberOfPoints: int) -> 'typing.Tuple[typing.Tuple[RealPoint2D_d6e70c78, ...], ...]':
        """
        Query subset of this poly-polygon, starting at the given polygon and the given point within that polygon, and containing the specified number of polygons and points in the last polygon.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def setPoint(self, point: 'RealPoint2D_d6e70c78', nPolygonIndex: int, nPointIndex: int) -> None:
        """
        Set a single point on the poly-polygon.
        
        The remaining points of the poly-polygon will not be changed by this method.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...
    @abstractmethod
    def setPoints(self, points: 'typing.Tuple[typing.Tuple[RealPoint2D_d6e70c78, ...], ...]', nPolygonIndex: int) -> None:
        """
        Set the specified sequence of points to the poly-polygon.
        
        This method can either set the whole poly-polygon to the new data, or insert the points at the given index

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
        ...

__all__ = ['XLinePolyPolygon2D']

