# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.scanner
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class ScannerContext(object):
    """
    Struct Class

    a scanner context is an identifier for a specific scanner device

    See Also:
        `API ScannerContext <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1scanner_1_1ScannerContext.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.scanner'
    __ooo_full_ns__: str = 'com.sun.star.scanner.ScannerContext'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.scanner.ScannerContext'
    """Literal Constant ``com.sun.star.scanner.ScannerContext``"""

    def __init__(self, ScannerName: typing.Optional[str] = '', InternalData: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            ScannerName (str, optional): ScannerName value.
            InternalData (int, optional): InternalData value.
        """
        super().__init__()

        if isinstance(ScannerName, ScannerContext):
            oth: ScannerContext = ScannerName
            self.ScannerName = oth.ScannerName
            self.InternalData = oth.InternalData
            return

        kargs = {
            "ScannerName": ScannerName,
            "InternalData": InternalData,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._scanner_name = kwargs["ScannerName"]
        self._internal_data = kwargs["InternalData"]


    @property
    def ScannerName(self) -> str:
        """
        ScannerName contains a user readable identification.
        """
        return self._scanner_name
    
    @ScannerName.setter
    def ScannerName(self, value: str) -> None:
        self._scanner_name = value

    @property
    def InternalData(self) -> int:
        """
        InternalData contains service private data and must not be changed.
        """
        return self._internal_data
    
    @InternalData.setter
    def InternalData(self, value: int) -> None:
        self._internal_data = value


__all__ = ['ScannerContext']
