# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .cell_delete_mode import CellDeleteMode as CellDeleteMode_d3830c79
    from .cell_insert_mode import CellInsertMode as CellInsertMode_d47d0c9b
    from ..table.cell_address import CellAddress as CellAddress_ae5f0b56
    from ..table.cell_range_address import CellRangeAddress as CellRangeAddress_ec450d43

class XCellRangeMovement(XInterface_8f010a43):
    """
    provides methods for moving ranges of cells in a sheet.

    See Also:
        `API XCellRangeMovement <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XCellRangeMovement.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XCellRangeMovement'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XCellRangeMovement'

    @abstractmethod
    def copyRange(self, aDestination: 'CellAddress_ae5f0b56', aSource: 'CellRangeAddress_ec450d43') -> None:
        """
        copies a cell range to another position in the document.
        
        The source cell range keeps unchanged.
        """
        ...
    @abstractmethod
    def insertCells(self, aRange: 'CellRangeAddress_ec450d43', nMode: 'CellInsertMode_d47d0c9b') -> None:
        """
        inserts cells, moving other cells down or right.
        
        Non-empty cells cannot be moved off the sheet.
        """
        ...
    @abstractmethod
    def moveRange(self, aDestination: 'CellAddress_ae5f0b56', aSource: 'CellRangeAddress_ec450d43') -> None:
        """
        moves a cell range to another position in the document.
        
        After copying the contents of the cell range, all cells will be cleared.
        """
        ...
    @abstractmethod
    def removeRange(self, aRange: 'CellRangeAddress_ec450d43', nMode: 'CellDeleteMode_d3830c79') -> None:
        """
        deletes cells, moving other cells up or left.
        """
        ...

__all__ = ['XCellRangeMovement']

