# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.style


class ParagraphStyleCategory(object):
    """
    Const Class

    These constants are used to specify the category of paragraph styles in text documents.

    See Also:
        `API ParagraphStyleCategory <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1style_1_1ParagraphStyleCategory.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.style'
    __ooo_full_ns__: str = 'com.sun.star.style.ParagraphStyleCategory'
    __ooo_type_name__: str = 'const'

    TEXT = 0
    """
    is applied to styles that are used for common text.
    """
    CHAPTER = 1
    """
    is applied to styles that are used as headings.
    """
    LIST = 2
    """
    is applied to styles that used in numberings and lists.
    """
    INDEX = 3
    """
    is applied to styles that are used in indexes.
    """
    EXTRA = 4
    """
    is applied to styles that are used in special regions like headers, footers, and footnote text.
    """
    HTML = 5
    """
    is applied to styles that are used to support HTML.
    """

__all__ = ['ParagraphStyleCategory']
