# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.ucb
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XContentIdentifier(XInterface_8f010a43):
    """
    An identifier for contents.

    See Also:
        `API XContentIdentifier <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ucb_1_1XContentIdentifier.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.XContentIdentifier'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.ucb.XContentIdentifier'

    @abstractmethod
    def getContentIdentifier(self) -> str:
        """
        returns the content identifier string.
        """
        ...
    @abstractmethod
    def getContentProviderScheme(self) -> str:
        """
        returns the content provider scheme string.
        
        This string will be calculated from the content identifier string and must be lower-cased(!). It is the \"scheme\" the content provider is registered for. In example, a provider for FTP contents will use ftp-URLs as content identifiers. The content provider scheme for all contents provided by that provider will be \"ftp\".
        """
        ...

__all__ = ['XContentIdentifier']

