# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.ucb
import typing
from abc import abstractmethod
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
if typing.TYPE_CHECKING:
    from .x_property_set_registry import XPropertySetRegistry as XPropertySetRegistry_c2e0e84

class XPersistentPropertySet(XPropertySet_bc180bfa):
    """
    A persistent property set, which can be saved in and restored from a XPropertySetRegistry.

    See Also:
        `API XPersistentPropertySet <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ucb_1_1XPersistentPropertySet.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.XPersistentPropertySet'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.ucb.XPersistentPropertySet'

    @abstractmethod
    def getKey(self) -> str:
        """
        returns the key used to address the set in the property set registry.
        """
        ...
    @abstractmethod
    def getRegistry(self) -> 'XPropertySetRegistry_c2e0e84':
        """
        returns the registry used to store the property set.
        """
        ...

__all__ = ['XPersistentPropertySet']

