# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ui
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class LayoutSize(object):
    """
    Struct Class

    Size used for layouting windows.
    
    It specifies a range of valid values and a preferred value. The values must not violate the relation 0 â¤ Minimum â¤ Preferred â¤ Maximum.

    See Also:
        `API LayoutSize <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ui_1_1LayoutSize.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ui'
    __ooo_full_ns__: str = 'com.sun.star.ui.LayoutSize'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ui.LayoutSize'
    """Literal Constant ``com.sun.star.ui.LayoutSize``"""

    def __init__(self, Minimum: typing.Optional[int] = 0, Maximum: typing.Optional[int] = 0, Preferred: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Minimum (int, optional): Minimum value.
            Maximum (int, optional): Maximum value.
            Preferred (int, optional): Preferred value.
        """
        super().__init__()

        if isinstance(Minimum, LayoutSize):
            oth: LayoutSize = Minimum
            self.Minimum = oth.Minimum
            self.Maximum = oth.Maximum
            self.Preferred = oth.Preferred
            return

        kargs = {
            "Minimum": Minimum,
            "Maximum": Maximum,
            "Preferred": Preferred,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._minimum = kwargs["Minimum"]
        self._maximum = kwargs["Maximum"]
        self._preferred = kwargs["Preferred"]


    @property
    def Minimum(self) -> int:
        return self._minimum
    
    @Minimum.setter
    def Minimum(self, value: int) -> None:
        self._minimum = value

    @property
    def Maximum(self) -> int:
        return self._maximum
    
    @Maximum.setter
    def Maximum(self, value: int) -> None:
        self._maximum = value

    @property
    def Preferred(self) -> int:
        return self._preferred
    
    @Preferred.setter
    def Preferred(self, value: int) -> None:
        self._preferred = value


__all__ = ['LayoutSize']
