# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class DateTimeRange(object):
    """
    Struct Class

    represents a range of date+time values.
    
    **since**
    
        LibreOffice 4.1

    See Also:
        `API DateTimeRange <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1DateTimeRange.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.DateTimeRange'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.util.DateTimeRange'
    """Literal Constant ``com.sun.star.util.DateTimeRange``"""

    def __init__(self, StartNanoSeconds: typing.Optional[int] = 0, StartSeconds: typing.Optional[int] = 0, StartMinutes: typing.Optional[int] = 0, StartHours: typing.Optional[int] = 0, StartDay: typing.Optional[int] = 0, StartMonth: typing.Optional[int] = 0, StartYear: typing.Optional[int] = 0, EndNanoSeconds: typing.Optional[int] = 0, EndSeconds: typing.Optional[int] = 0, EndMinutes: typing.Optional[int] = 0, EndHours: typing.Optional[int] = 0, EndDay: typing.Optional[int] = 0, EndMonth: typing.Optional[int] = 0, EndYear: typing.Optional[int] = 0, IsUTC: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            StartNanoSeconds (int, optional): StartNanoSeconds value.
            StartSeconds (int, optional): StartSeconds value.
            StartMinutes (int, optional): StartMinutes value.
            StartHours (int, optional): StartHours value.
            StartDay (int, optional): StartDay value.
            StartMonth (int, optional): StartMonth value.
            StartYear (int, optional): StartYear value.
            EndNanoSeconds (int, optional): EndNanoSeconds value.
            EndSeconds (int, optional): EndSeconds value.
            EndMinutes (int, optional): EndMinutes value.
            EndHours (int, optional): EndHours value.
            EndDay (int, optional): EndDay value.
            EndMonth (int, optional): EndMonth value.
            EndYear (int, optional): EndYear value.
            IsUTC (bool, optional): IsUTC value.
        """
        super().__init__()

        if isinstance(StartNanoSeconds, DateTimeRange):
            oth: DateTimeRange = StartNanoSeconds
            self.StartNanoSeconds = oth.StartNanoSeconds
            self.StartSeconds = oth.StartSeconds
            self.StartMinutes = oth.StartMinutes
            self.StartHours = oth.StartHours
            self.StartDay = oth.StartDay
            self.StartMonth = oth.StartMonth
            self.StartYear = oth.StartYear
            self.EndNanoSeconds = oth.EndNanoSeconds
            self.EndSeconds = oth.EndSeconds
            self.EndMinutes = oth.EndMinutes
            self.EndHours = oth.EndHours
            self.EndDay = oth.EndDay
            self.EndMonth = oth.EndMonth
            self.EndYear = oth.EndYear
            self.IsUTC = oth.IsUTC
            return

        kargs = {
            "StartNanoSeconds": StartNanoSeconds,
            "StartSeconds": StartSeconds,
            "StartMinutes": StartMinutes,
            "StartHours": StartHours,
            "StartDay": StartDay,
            "StartMonth": StartMonth,
            "StartYear": StartYear,
            "EndNanoSeconds": EndNanoSeconds,
            "EndSeconds": EndSeconds,
            "EndMinutes": EndMinutes,
            "EndHours": EndHours,
            "EndDay": EndDay,
            "EndMonth": EndMonth,
            "EndYear": EndYear,
            "IsUTC": IsUTC,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._start_nano_seconds = kwargs["StartNanoSeconds"]
        self._start_seconds = kwargs["StartSeconds"]
        self._start_minutes = kwargs["StartMinutes"]
        self._start_hours = kwargs["StartHours"]
        self._start_day = kwargs["StartDay"]
        self._start_month = kwargs["StartMonth"]
        self._start_year = kwargs["StartYear"]
        self._end_nano_seconds = kwargs["EndNanoSeconds"]
        self._end_seconds = kwargs["EndSeconds"]
        self._end_minutes = kwargs["EndMinutes"]
        self._end_hours = kwargs["EndHours"]
        self._end_day = kwargs["EndDay"]
        self._end_month = kwargs["EndMonth"]
        self._end_year = kwargs["EndYear"]
        self._is_utc = kwargs["IsUTC"]


    @property
    def StartNanoSeconds(self) -> int:
        """
        contains the start nanoseconds (0 - 999 999 999) for the range.
        """
        return self._start_nano_seconds
    
    @StartNanoSeconds.setter
    def StartNanoSeconds(self, value: int) -> None:
        self._start_nano_seconds = value

    @property
    def StartSeconds(self) -> int:
        """
        contains the start seconds (0-59) for the range.
        """
        return self._start_seconds
    
    @StartSeconds.setter
    def StartSeconds(self, value: int) -> None:
        self._start_seconds = value

    @property
    def StartMinutes(self) -> int:
        """
        contains the start minutes (0-59) for the range.
        """
        return self._start_minutes
    
    @StartMinutes.setter
    def StartMinutes(self, value: int) -> None:
        self._start_minutes = value

    @property
    def StartHours(self) -> int:
        """
        contains the start hour (0-23) for the range.
        """
        return self._start_hours
    
    @StartHours.setter
    def StartHours(self, value: int) -> None:
        self._start_hours = value

    @property
    def StartDay(self) -> int:
        """
        contains the start day of month (1-31 or 0 for a void date) for the range.
        """
        return self._start_day
    
    @StartDay.setter
    def StartDay(self, value: int) -> None:
        self._start_day = value

    @property
    def StartMonth(self) -> int:
        """
        contains the start month of year (1-12 or 0 for a void date) for the range.
        """
        return self._start_month
    
    @StartMonth.setter
    def StartMonth(self, value: int) -> None:
        self._start_month = value

    @property
    def StartYear(self) -> int:
        """
        contains the start year for the range.
        """
        return self._start_year
    
    @StartYear.setter
    def StartYear(self, value: int) -> None:
        self._start_year = value

    @property
    def EndNanoSeconds(self) -> int:
        """
        contains the end nanoseconds (0 - 999 999 999) for the range.
        """
        return self._end_nano_seconds
    
    @EndNanoSeconds.setter
    def EndNanoSeconds(self, value: int) -> None:
        self._end_nano_seconds = value

    @property
    def EndSeconds(self) -> int:
        """
        contains the end seconds (0-59) for the range.
        """
        return self._end_seconds
    
    @EndSeconds.setter
    def EndSeconds(self, value: int) -> None:
        self._end_seconds = value

    @property
    def EndMinutes(self) -> int:
        """
        contains the end minutes (0-59) for the range.
        """
        return self._end_minutes
    
    @EndMinutes.setter
    def EndMinutes(self, value: int) -> None:
        self._end_minutes = value

    @property
    def EndHours(self) -> int:
        """
        contains the end hour (0-23) for the range.
        """
        return self._end_hours
    
    @EndHours.setter
    def EndHours(self, value: int) -> None:
        self._end_hours = value

    @property
    def EndDay(self) -> int:
        """
        contains the end day of month (1-31 or 0 for a void date) for the range.
        """
        return self._end_day
    
    @EndDay.setter
    def EndDay(self, value: int) -> None:
        self._end_day = value

    @property
    def EndMonth(self) -> int:
        """
        contains the end month of year (1-12 or 0 for a void date) for the range.
        """
        return self._end_month
    
    @EndMonth.setter
    def EndMonth(self, value: int) -> None:
        self._end_month = value

    @property
    def EndYear(self) -> int:
        """
        contains the end year for the range.
        """
        return self._end_year
    
    @EndYear.setter
    def EndYear(self, value: int) -> None:
        self._end_year = value

    @property
    def IsUTC(self) -> bool:
        """
        true: time zone is UTC false: unknown time zone.
        
        **since**
        
            LibreOffice 4.1
        """
        return self._is_utc
    
    @IsUTC.setter
    def IsUTC(self, value: bool) -> None:
        self._is_utc = value


__all__ = ['DateTimeRange']
