# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.util
import uno
from abc import abstractmethod, ABC

class XBinaryDataContainer(ABC):
    """
    Container for binary data, typically an in-memory content of files.
    
    The binary data in the container is regarded as read-only so no access that would allow changing the data is allowed in this interface.
    
    **since**
    
        LibreOffice 7.2

    See Also:
        `API XBinaryDataContainer <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1util_1_1XBinaryDataContainer.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.XBinaryDataContainer'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.util.XBinaryDataContainer'

    @abstractmethod
    def getCopyAsByteSequence(self) -> uno.ByteSequence:
        """
        Get a copy of the contained data.
        """
        ...

__all__ = ['XBinaryDataContainer']

