# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.util
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XStringEscape(XInterface_8f010a43):
    """
    This interface is used to encode an arbitrary String into a escaped form.
    
    The escaped form is chosen to be suitable for use with other interfaces of the object or service providing this interface.
    
    Any characters or character sequences that are not compatible with any naming rules or restrictions must be replaced by an escaped form, that complies to these rules.
    
    The transformation should preserve all traits of the string that are generally respected by the service. For example, the case of a string may be lost after encoding and then decoding, if the service generally is case insensitive.
    
    Other than that the encoding is one-to-one and can be reversed. The encoding should try to preserve as much as possible of the original string, to keep human-readable input human-friendly where possible. Strings that already conform to the naming conventions should be left unchanged or minimally modified.

    See Also:
        `API XStringEscape <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1util_1_1XStringEscape.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.XStringEscape'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.util.XStringEscape'

    @abstractmethod
    def escapeString(self, aString: str) -> str:
        """
        encodes an arbitrary string into an escaped form compatible with some naming rules.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def unescapeString(self, aEscapedString: str) -> str:
        """
        decodes an escaped string into the original form.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...

__all__ = ['XStringEscape']

