# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.xml.crypto
import typing
from abc import abstractmethod
from .xxml_security_template import XXMLSecurityTemplate as XXMLSecurityTemplate_79221105
if typing.TYPE_CHECKING:
    from ..wrapper.xxml_element_wrapper import XXMLElementWrapper as XXMLElementWrapper_66c0107c

class XXMLEncryptionTemplate(XXMLSecurityTemplate_79221105):
    """
    Interface of XML encryption template.
    
    This interface represents an encryption template, which is the same as the desired XML encryption element[ EncryptedType ] but some of the nodes may be empty. The empty entities include CipherValue, which is a subset of EncryptedData or EncryptedKey. Empty entities are not allowed in an encryption template when performing decryption.
    
    In some cases, the encryptor or decryptor can determine and locate the EncryptedKey from the encryption template by dereference the RetrievalMethod inside EncryptedData.
    
    In some cases, the EncryptedKey need to be clearly pointed out by the encryption template.
    
    With the help of encryption context, the encryptor or decryptor specifies the key from the KeyInfo in the encryption template.
    
    It isn't a good method to set the EncryptedKey here. In general, there is a RetrievalMethod in EncryptedData by which we can get the EncryptedKey.
    
    And sometimes, in the low level, it is hard to determine what the key is except that the high level application tell the mechanism and parameters.
    
    So I think it will be more simple that the application set the encrypted key information. In this case, the application only need to know the XML schema or DTD and the encryption device. If so, the high level application takes the action of build the EncryptedKey template and references it in the element of EncryptedData. And in this case, the calling to set up EncryptedKey template and target is not necessary, because the encryptor or decryptor can determine and locate the EncryptedKey from the encryption template of EncryptedData by dereference the RetrievalMethod.
    
    In some situation, the high level applications do not want to know anything about crypto devices( May be he must, because the lower level do not know what the key is ). If it gives the key value, it can get EncryptedKey by setting the key template and key value target.

    See Also:
        `API XXMLEncryptionTemplate <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1xml_1_1crypto_1_1XXMLEncryptionTemplate.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.xml.crypto'
    __ooo_full_ns__: str = 'com.sun.star.xml.crypto.XXMLEncryptionTemplate'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.xml.crypto.XXMLEncryptionTemplate'

    @abstractmethod
    def getTarget(self) -> 'XXMLElementWrapper_66c0107c':
        """
        Get the target XML element, i.e.
        
        the element to be encrypted
        """
        ...

__all__ = ['XXMLEncryptionTemplate']

