# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.xml.sax
import typing
from abc import abstractmethod, abstractproperty
from .x_fast_context_handler import XFastContextHandler as XFastContextHandler_361e0f5c
if typing.TYPE_CHECKING:
    from ...awt.point import Point as Point_5fb2085e
    from ...beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ...document.x_document_properties import XDocumentProperties as XDocumentProperties_4c31102b
    from ...drawing.x_draw_page import XDrawPage as XDrawPage_b07a0b57
    from ...drawing.x_shape import XShape as XShape_8fd00a3d
    from ...frame.x_model import XModel as XModel_7a6e095c
    from ...graphic.x_graphic_mapper import XGraphicMapper as XGraphicMapper_eec10d61

class XFastShapeContextHandler(XFastContextHandler_361e0f5c):
    """
    receives notification of sax document events from a XFastParser.
    
    **since**
    
        LibreOffice 7.1

    See Also:
        `API XFastShapeContextHandler <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1xml_1_1sax_1_1XFastShapeContextHandler.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.xml.sax'
    __ooo_full_ns__: str = 'com.sun.star.xml.sax.XFastShapeContextHandler'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.xml.sax.XFastShapeContextHandler'

    @abstractmethod
    def setGraphicMapper(self, xGraphicMapper: 'XGraphicMapper_eec10d61') -> None:
        """
        Graphic mapper to map a key/id string to a XGraphic.
        
        This is needed to remember for XGraphics for a path in the document storage
        
        **since**
        
            LibreOffice 7.1
        """
        ...
    @abstractproperty
    def MediaDescriptor(self) -> 'typing.Tuple[PropertyValue_c9610c73, ...]':
        """
        """
        ...

    @abstractproperty
    def DocumentProperties(self) -> 'XDocumentProperties_4c31102b':
        """
        """
        ...

    @abstractproperty
    def DrawPage(self) -> 'XDrawPage_b07a0b57':
        """
        """
        ...

    @abstractproperty
    def Model(self) -> 'XModel_7a6e095c':
        """
        """
        ...

    @abstractproperty
    def Position(self) -> 'Point_5fb2085e':
        """
        """
        ...

    @abstractproperty
    def RelationFragmentPath(self) -> str:
        """
        """
        ...

    @abstractproperty
    def Shape(self) -> 'XShape_8fd00a3d':
        """
        """
        ...

    @abstractproperty
    def StartToken(self) -> int:
        """
        """
        ...


__all__ = ['XFastShapeContextHandler']

