# make sure we can import from package directory
import sys, os
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

import unittest
import string
import math
import io
import amplimap.common
import amplimap.reader
from amplimap.reader import *

class Reader(unittest.TestCase):
    def test_mipgen_convert(self):
        # single change (case from MIPGEN practice files)
        f = io.StringIO(""">mip_key	logistic_score	chr	ext_probe_start	ext_probe_stop	ext_probe_copy	ext_probe_sequence	lig_probe_start	lig_probe_stop	lig_probe_copy	lig_probe_sequence	mip_scan_start_position	mip_scan_stop_position	scan_target_sequence	mip_sequence	feature_start_position	feature_stop_position	probe_strand	failure_flags	mip_name
5:1253823-1253984/17,23/+	0.798319	5	1253823	1253839	2	TGGCTGTGGGCGGGTGG	1253962	1253984	1	CAGACTCCGTTCCAGAAGAGGCC	1253840	1253961	CCATCAGTCCAGGATGGTCTTGAAGTCTGAGGGCAGTGCCGGGTTGGCTGCGGCCTCCAGGGCAGTCAGCGTCGTCCCCGGGAGCTTCCGACTCAGCTGCGTCTGGGCTGCGGGGCCAAAAT	CAGACTCCGTTCCAGAAGAGGCCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTGGCTGTGGGCGGGTGG	1253842	1253946	+	000	TERT/NM_001193376_0001
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	TCTGGATGTGGCATGTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATGTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028_SNP_a
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	TCTGGATGTGGCATCTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATCTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028_SNP_b""")
        probes = amplimap.reader.read_and_convert_mipgen_probes(f, sep='\t')

        assert len(probes) == 2
        assert probes.iloc[1]['id'] == 'TERT/NM_001193376_0028'
        assert probes.iloc[1]['second_primer_5to3'] == 'TCTGGATGTGGCAT.TCCTTCTCGTT'
        
        # multiple changes
        f = io.StringIO(""">mip_key	logistic_score	chr	ext_probe_start	ext_probe_stop	ext_probe_copy	ext_probe_sequence	lig_probe_start	lig_probe_stop	lig_probe_copy	lig_probe_sequence	mip_scan_start_position	mip_scan_stop_position	scan_target_sequence	mip_sequence	feature_start_position	feature_stop_position	probe_strand	failure_flags	mip_name
5:1253823-1253984/17,23/+	0.798319	5	1253823	1253839	2	TGGCTGTGGGCGGGTGG	1253962	1253984	1	CAGACTCCGTTCCAGAAGAGGCC	1253840	1253961	CCATCAGTCCAGGATGGTCTTGAAGTCTGAGGGCAGTGCCGGGTTGGCTGCGGCCTCCAGGGCAGTCAGCGTCGTCCCCGGGAGCTTCCGACTCAGCTGCGTCTGGGCTGCGGGGCCAAAAT	CAGACTCCGTTCCAGAAGAGGCCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTGGCTGTGGGCGGGTGG	1253842	1253946	+	000	TERT/NM_001193376_0001
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	AAAGGATGTGGCATGTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATGTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028_SNP_a
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	CCCGGATGTGGCATCTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATCTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028_SNP_b""")
        probes = amplimap.reader.read_and_convert_mipgen_probes(f, sep='\t')

        assert len(probes) == 2
        assert probes.iloc[1]['id'] == 'TERT/NM_001193376_0028'
        assert probes.iloc[1]['second_primer_5to3'] == '...GGATGTGGCAT.TCCTTCTCGTT'
        
        # different IDs, no changes
        f = io.StringIO(""">mip_key	logistic_score	chr	ext_probe_start	ext_probe_stop	ext_probe_copy	ext_probe_sequence	lig_probe_start	lig_probe_stop	lig_probe_copy	lig_probe_sequence	mip_scan_start_position	mip_scan_stop_position	scan_target_sequence	mip_sequence	feature_start_position	feature_stop_position	probe_strand	failure_flags	mip_name
5:1253823-1253984/17,23/+	0.798319	5	1253823	1253839	2	TGGCTGTGGGCGGGTGG	1253962	1253984	1	CAGACTCCGTTCCAGAAGAGGCC	1253840	1253961	CCATCAGTCCAGGATGGTCTTGAAGTCTGAGGGCAGTGCCGGGTTGGCTGCGGCCTCCAGGGCAGTCAGCGTCGTCCCCGGGAGCTTCCGACTCAGCTGCGTCTGGGCTGCGGGGCCAAAAT	CAGACTCCGTTCCAGAAGAGGCCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTGGCTGTGGGCGGGTGG	1253842	1253946	+	000	TERT/NM_001193376_0001
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	AAAGGATGTGGCATGTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATGTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028_SNP_a
5:1282608-1282769/26,19/-	0.909748	5	1282744	1282769	1	CCCGGATGTGGCATCTCCTTCTCGTT	1282608	1282626	1	GTCACGGAGACCACGTTTC	1282627	1282743	TAAGGGGTTGGCTGTGTTCCGGCCGCAGAGCACCGTCTGCGTGAGGAGATCCTGGCCAAGTTCCTGCACTGGCTGATGAGTGTGTACGTCGTCGAGCTGCTCAGGTCTTTCTTTTAT	GTCACGGAGACCACGTTTCCTTCAGCTTCCCGATATCCGACGGTAGTGTNNNNNTCTGGATGTGGCATCTCCTTCTCGTT	1282543	1282739	-	000	TERT/NM_001193376_0028XXX_SNP_b""")
        probes = amplimap.reader.read_and_convert_mipgen_probes(f, sep='\t')

        assert len(probes) == 3
        assert probes.iloc[1]['id'] == 'TERT/NM_001193376_0028'
        assert probes.iloc[1]['second_primer_5to3'] == 'AAAGGATGTGGCATGTCCTTCTCGTT'
        assert probes.iloc[2]['id'] == 'TERT/NM_001193376_0028XXX'
        assert probes.iloc[2]['second_primer_5to3'] == 'CCCGGATGTGGCATCTCCTTCTCGTT'

if __name__ == '__main__':
    unittest.main()