"""extend models to support attributes and external urls

Revision ID: 6008fc1fee35
Revises: 3ef406d9f379
Create Date: 2021-09-13 21:15:29.013923

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "6008fc1fee35"
down_revision = "3ef406d9f379"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "externalurl",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column(
            "date_created",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_updated",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "url", sa.String(length=256), nullable=True, comment="External URL for this metadata"
        ),
        sa.Column(
            "name", sa.String(length=256), nullable=True, comment="External URL service name"
        ),
        sa.Column("meta_data_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["meta_data_id"],
            ["metadata.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "metadataattribute",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column(
            "date_created",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_updated",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=128), nullable=False),
        sa.Column("value", sa.String(length=256), nullable=True),
        sa.Column("value_type", sa.String(length=16), nullable=False),
        sa.Column("meta_data_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["meta_data_id"],
            ["metadata.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("metadataattribute")
    op.drop_table("externalurl")
    # ### end Alembic commands ###
