"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BalancerEntry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_elasticloadbalancingv2_1 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
class BalancerEntry extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const listeners = this.getLoadBalancerListener(props.lbArn, props.sslEnabled, props.appName);
        if (props.sslEnabled) {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-https-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
        else {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-http-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
    }
    getLoadBalancerListener(loadBalancerArn, sslEnabled, appName) {
        const listeners = [];
        if (!sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-http', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTP,
            }).listenerArn);
        }
        if (sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-https', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTPS,
            }).listenerArn);
        }
        return listeners;
    }
}
exports.BalancerEntry = BalancerEntry;
_a = JSII_RTTI_SYMBOL_1;
BalancerEntry[_a] = { fqn: "@smallcase/aws-cdk-microservice.BalancerEntry", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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