from easytradesdk.indicator.SimpleIndicator import SimpleIndicator
import talib._ta_lib as ta


class Tema(SimpleIndicator):

    def __init__(self):
        super(Tema, self).__init__()

    @staticmethod
    def generate(np_closing_price_array, time_periods):

        if (np_closing_price_array is None or len(np_closing_price_array) == 0):
            return []

        _tema_tmp_dict = {}
        for _t in range(0, len(time_periods)):
            _time_period = time_periods[_t]
            _tema_tmp_dict[_time_period] = ta.TEMA(np_closing_price_array, timeperiod=_time_period)
        _tema_list = []
        for _index in range(0, len(np_closing_price_array)):
            _tema = Tema()
            for t in range(0, len(time_periods)):
                _time_period = time_periods[t]
                _np_tema_array = _tema_tmp_dict[_time_period]
                _tema_value = _np_tema_array[_index]

                if _tema_value is not None:
                    _tema.setValue(_tema_value, _time_period)
                else:
                    _tema.setValue(None, _time_period)
            _tema_list.append(_tema)

        return _tema_list
