"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Automation = void 0;
class Automation {
    constructor(project, props = {}) {
        var _a;
        this.project = project;
        this.automationToken = (_a = props.automationToken) !== null && _a !== void 0 ? _a : 'GITHUB_TOKEN';
    }
    autoMerge() {
        if (this.project.github) {
            // auto merge workflow
            const autoMerge = this.project.github.addWorkflow('AutoMerge');
            autoMerge.on({
                pull_request: {
                    types: ['labeled', 'opened', 'reopened'],
                },
                check_suite: {
                    types: ['completed'],
                },
                status: {},
            });
            autoMerge.addJobs({
                automerge: {
                    'runs-on': 'ubuntu-latest',
                    'steps': [
                        {
                            name: 'automerge',
                            uses: 'pascalgn/automerge-action@v0.13.1',
                            env: {
                                GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                                MERGE_LABELS: 'auto-merge,!wip,!work in progress,!do-not-merge',
                                MERGE_RETRY_SLEEP: '60000',
                                MERGE_DELETE_BRANCH: 'true',
                            },
                        },
                    ],
                },
            });
        }
        ;
    }
    ;
    autoApprove() {
        if (this.project.github) {
            const autoApprove = this.project.github.addWorkflow('AutoApprove');
            autoApprove.on({
                pull_request_target: {
                    types: ['assigned', 'opened', 'synchronize', 'reopened'],
                },
            });
            autoApprove.addJobs({
                'auto-approve': {
                    'runs-on': 'ubuntu-latest',
                    'steps': [
                        {
                            uses: 'hmarr/auto-approve-action@v2.0.0',
                            if: "github.actor == 'pahud' || contains( github.event.pull_request.labels.*.name, 'auto-approve')",
                            with: {
                                'github-token': '${{ secrets.GITHUB_TOKEN }}',
                            },
                        },
                    ],
                },
            });
        }
        ;
    }
    ;
    projenYarnUpgrade() {
        if (this.project.github) {
            const projenYarnUpgrade = this.project.github.addWorkflow('ProjenYarnUpgrade');
            projenYarnUpgrade.on({
                schedule: [{
                        cron: '11 0 * * *',
                    }],
                workflow_dispatch: {},
            });
            projenYarnUpgrade.addJobs({
                upgrade: {
                    'runs-on': 'ubuntu-latest',
                    'steps': [
                        { uses: 'actions/checkout@v2' },
                        {
                            uses: 'actions/setup-node@v1',
                            with: {
                                'node-version': '10.17.0',
                            },
                        },
                        { run: 'yarn upgrade' },
                        { run: 'yarn projen:upgrade' },
                        // submit a PR
                        {
                            name: 'Create Pull Request',
                            uses: 'peter-evans/create-pull-request@v3',
                            with: {
                                'token': '${{ secrets.' + this.automationToken + ' }}',
                                'commit-message': 'chore: upgrade projen',
                                'branch': 'auto/projen-upgrade',
                                'title': 'chore: upgrade projen and yarn',
                                'body': 'This PR upgrades projen and yarn upgrade to the latest version',
                                'labels': 'auto-merge,auto-approve',
                            },
                        },
                    ],
                },
            });
        }
    }
}
exports.Automation = Automation;
//# sourceMappingURL=data:application/json;base64,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