"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const yargs = require("yargs");
const common_1 = require("../common");
const project_1 = require("../project");
const tasks_1 = require("../tasks");
const synth_1 = require("./synth");
const tasks_2 = require("./tasks");
const DEFAULT_RC = path_1.resolve(common_1.PROJEN_RC);
async function main() {
    var _a;
    const ya = yargs;
    ya.commandDir('cmds');
    const runtime = new tasks_1.TaskRuntime('.');
    tasks_2.discoverTaskCommands(runtime, ya);
    ya.recommendCommands();
    ya.strictCommands();
    ya.wrap(yargs.terminalWidth());
    ya.option('post', { type: 'boolean', default: true, desc: 'Run post-synthesis steps such as installing dependencies. Use --no-post to skip' });
    ya.options('debug', { type: 'boolean', default: false, desc: 'Debug logs' });
    ya.options('rc', { desc: 'path to .projenrc.js file', default: DEFAULT_RC, type: 'string' });
    ya.version(false);
    ya.help();
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = 'true';
    }
    // no command means just require .projenrc.js
    if (args._.length === 0) {
        process.env.PROJEN_DISABLE_POST = (!args.post).toString();
        // if there is a "default" task, execute it, otherwise, defer to the javascript synth
        // TODO: move javascript synth to `NodeProject`.
        const defaultTask = runtime.tasks.find(t => t.name === project_1.Project.DEFAULT_TASK);
        if (defaultTask) {
            runtime.runTask(defaultTask.name);
        }
        else {
            await synth_1.synth((_a = args.rc) !== null && _a !== void 0 ? _a : DEFAULT_RC);
        }
    }
}
main().catch(e => {
    console.error(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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