# Assumptions & considerations

## Core assumptions

I consider the following assumptions a given. They are not fuelled by user stories, but are the 'minimal' requirements
that emerged after initially presenting the 'open questions', and in other discussions with Sean and the team. If any
of those assumptions are wrong, some of the conclusions below will have to be adjusted.

- our (only) target audience (for now) are digital historians (and maybe also other digital humanity researchers) who can't code themselves
- the most important outcome of our project is for our target audience to be able to execute workflows in order to explore, explain, transform or augment their data
- we want the creation of workflows to be as easy and frictionless as possible, although not at the expense of end-user usability
- we want our product to be used by all DH researchers around the word, independent of their affiliation(s)
q- collaboration/sharing of data is not a priority, most of our target audience are either individuals, sometimes small teams (sharing of results and sharing of workflows are different issues, and not included in this assumption)

## Considerations around adoption

One way to look at how to prioritize and implement some of our user stories is through the lens of ease-of-adoption:
which characteristics make our application more likely to be adopted, by a larger group of researchers?

Those ones are obvious (at least to me) -- in no particular order:

 - ease of workflow use
 - ease of file-management use
 - ease of installation (if there is one involved)
 - whether there is a login/account creation requirement
 - how well it integrates and plays with tools researchers already use day to day
 - provides relevant (to them) workflows
 - the cheaper to use the better (free/monthly cost/pay-per-usage)
 - stability / reliability
 - performance (most importantly on the compute side, but also UI)
 - how easy it is to create workflows, and what skills are necessary to do that (easier creation -> more workflows)
 - whether and how easy it will be to share, re-use and adapt workflows (different to sharing data)
