/// Files: arch/powerpc/kernel/process.c
/// Fix: 8205d5d98ef7f155de211f5e2eb6ca03d95a5a60
/// Fixes: f48e91e87e67b56bef63393d1a02c6e22c1d7078

virtual detect

@tm_reclaim_thread exists@
identifier thr;
@@

tm_reclaim_thread(struct thread_struct *thr,...)
{
	...
*	if ((thr->ckpt_regs.msr & MSR_FP) == 0)
*		memcpy(&thr->ckfp_state, &thr->fp_state, ...);
*	if ((thr->ckpt_regs.msr & MSR_VEC) == 0)
*		memcpy(&thr->ckvr_state, &thr->vr_state, ...);
	...
}

@err depends on tm_reclaim_thread exists@
identifier tsk;
position p;
@@

giveup_all(struct task_struct *tsk)
{
	...
	usermsr = tsk->thread.regs->msr;
	...
*	check_if_tm_restore_required@p(tsk);
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-15030')
