# Generated by Django 2.2.13 on 2021-02-13 15:36

import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("models", "7043_sort_results"),
    ]

    operations = [
        migrations.CreateModel(
            name="GeoJSONGeometry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("geom", django.contrib.gis.db.models.fields.GeometryField(srid=3857)),
            ],
            options={
                "db_table": "geojson_geometries",
                "managed": True,
            },
        ),
        migrations.AddField(
            model_name="geojsongeometry",
            name="node",
            field=models.ForeignKey(db_column="nodeid", on_delete=django.db.models.deletion.CASCADE, to="models.Node"),
        ),
        migrations.AddField(
            model_name="geojsongeometry",
            name="resourceinstance",
            field=models.ForeignKey(
                db_column="resourceinstanceid", on_delete=django.db.models.deletion.CASCADE, to="models.ResourceInstance"
            ),
        ),
        migrations.AddField(
            model_name="geojsongeometry",
            name="tile",
            field=models.ForeignKey(db_column="tileid", on_delete=django.db.models.deletion.CASCADE, to="models.TileModel"),
        ),
        migrations.RunSQL(
            """
            CREATE OR REPLACE FUNCTION refresh_geojson_geometries() RETURNS BOOLEAN AS $$
                    BEGIN
                        TRUNCATE TABLE geojson_geometries;

                        INSERT INTO geojson_geometries(
                            tileid,
                            resourceinstanceid,
                            nodeid,
                            geom
                        )
                        SELECT t.tileid,
                            t.resourceinstanceid,
                            n.nodeid,
                            ST_Force2D(
                                ST_Transform(
                                    ST_SetSRID(
                                        st_geomfromgeojson(
                                            (
                                                json_array_elements(
                                                    t.tiledata::json->n.nodeid::text->'features'
                                                )->'geometry'
                                            )::text
                                        ),
                                        4326
                                    ),
                                    3857
                                )
                            ) AS geom
                        FROM tiles t
                            LEFT JOIN nodes n ON t.nodegroupid = n.nodegroupid
                        WHERE n.datatype = 'geojson-feature-collection'::text;

                        RETURN TRUE;
                    END;
            $$ LANGUAGE plpgsql;

            CREATE OR REPLACE FUNCTION refresh_tile_geojson_geometries(refreshtileid UUID) RETURNS BOOLEAN AS $$
                    BEGIN
                        DELETE FROM geojson_geometries WHERE tileid = refreshtileid;

                        INSERT INTO geojson_geometries(
                            tileid,
                            resourceinstanceid,
                            nodeid,
                            geom
                        )
                        SELECT t.tileid,
                            t.resourceinstanceid,
                            n.nodeid,
                            ST_Force2D(
                                ST_Transform(
                                    ST_SetSRID(
                                        st_geomfromgeojson(
                                            (
                                                json_array_elements(
                                                    t.tiledata::json->n.nodeid::text->'features'
                                                )->'geometry'
                                            )::text
                                        ),
                                        4326
                                    ),
                                    3857
                                )
                            ) AS geom
                        FROM tiles t
                            LEFT JOIN nodes n ON t.nodegroupid = n.nodegroupid
                        WHERE n.datatype = 'geojson-feature-collection'::text
                        AND t.tileid = refreshtileid;

                        RETURN TRUE;
                    END;
            $$ LANGUAGE plpgsql;

            CREATE INDEX geojson_geometries_gix ON geojson_geometries USING GIST (geom);
            SELECT refresh_geojson_geometries();
            """,
            """
            DROP INDEX geojson_geometries_gix;
            DROP FUNCTION refresh_geojson_geometries, refresh_tile_geojson_geometries;
            """,
        ),
    ]
