import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaterializedViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the view.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#comment MaterializedView#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the view. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#database MaterializedView#database}
    */
    readonly database: string;
    /**
    * Specifies that the view is secure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#is_secure MaterializedView#is_secure}
    */
    readonly isSecure?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the view; must be unique for the schema in which the view is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#name MaterializedView#name}
    */
    readonly name: string;
    /**
    * Overwrites the View if it exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#or_replace MaterializedView#or_replace}
    */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
    * The schema in which to create the view. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#schema MaterializedView#schema}
    */
    readonly schema: string;
    /**
    * Specifies the query used to create the view.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#statement MaterializedView#statement}
    */
    readonly statement: string;
    /**
    * The warehouse name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#warehouse MaterializedView#warehouse}
    */
    readonly warehouse: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#tag MaterializedView#tag}
    */
    readonly tag?: MaterializedViewTag[] | cdktf.IResolvable;
}
export interface MaterializedViewTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#database MaterializedView#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#name MaterializedView#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#schema MaterializedView#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#value MaterializedView#value}
    */
    readonly value: string;
}
export declare function materializedViewTagToTerraform(struct?: MaterializedViewTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view snowflake_materialized_view}
*/
export declare class MaterializedView extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_materialized_view";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view snowflake_materialized_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaterializedViewConfig
    */
    constructor(scope: Construct, id: string, config: MaterializedViewConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _isSecure?;
    get isSecure(): boolean | cdktf.IResolvable;
    set isSecure(value: boolean | cdktf.IResolvable);
    resetIsSecure(): void;
    get isSecureInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orReplace?;
    get orReplace(): boolean | cdktf.IResolvable;
    set orReplace(value: boolean | cdktf.IResolvable);
    resetOrReplace(): void;
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    get statementInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    get warehouseInput(): string | undefined;
    private _tag?;
    get tag(): MaterializedViewTag[] | cdktf.IResolvable;
    set tag(value: MaterializedViewTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | MaterializedViewTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=materialized-view.d.ts.map