import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StageGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database containing the current stage on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#database_name StageGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#enable_multiple_grants StageGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * When this is set to true and a schema_name is provided, apply this grant on all future stages in the given schema. When this is true and no schema_name is provided apply this grant on all future stages in the given database. The stage_name field must be unset in order to use on_future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#on_future StageGrant#on_future}
    */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#privilege StageGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#roles StageGrant#roles}
    */
    readonly roles?: string[];
    /**
    * The name of the schema containing the current stage on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#schema_name StageGrant#schema_name}
    */
    readonly schemaName: string;
    /**
    * The name of the stage on which to grant privilege (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#stage_name StageGrant#stage_name}
    */
    readonly stageName?: string;
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant#with_grant_option StageGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant snowflake_stage_grant}
*/
export declare class StageGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stage_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/stage_grant snowflake_stage_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StageGrantConfig
    */
    constructor(scope: Construct, id: string, config: StageGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _onFuture?;
    get onFuture(): boolean | cdktf.IResolvable;
    set onFuture(value: boolean | cdktf.IResolvable);
    resetOnFuture(): void;
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _stageName?;
    get stageName(): string;
    set stageName(value: string);
    resetStageName(): void;
    get stageNameInput(): string | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=stage-grant.d.ts.map