import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#aws_external_id Stage#aws_external_id}
    */
    readonly awsExternalId?: string;
    /**
    * Specifies a comment for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#comment Stage#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the copy options for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#copy_options Stage#copy_options}
    */
    readonly copyOptions?: string;
    /**
    * Specifies the credentials for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#credentials Stage#credentials}
    */
    readonly credentials?: string;
    /**
    * The database in which to create the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#database Stage#database}
    */
    readonly database: string;
    /**
    * Specifies the directory settings for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#directory Stage#directory}
    */
    readonly directory?: string;
    /**
    * Specifies the encryption settings for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#encryption Stage#encryption}
    */
    readonly encryption?: string;
    /**
    * Specifies the file format for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#file_format Stage#file_format}
    */
    readonly fileFormat?: string;
    /**
    * Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#name Stage#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#schema Stage#schema}
    */
    readonly schema: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#snowflake_iam_user Stage#snowflake_iam_user}
    */
    readonly snowflakeIamUser?: string;
    /**
    * Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#storage_integration Stage#storage_integration}
    */
    readonly storageIntegration?: string;
    /**
    * Specifies the URL for the stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#url Stage#url}
    */
    readonly url?: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#tag Stage#tag}
    */
    readonly tag?: StageTag[] | cdktf.IResolvable;
}
export interface StageTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#database Stage#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#name Stage#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#schema Stage#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#value Stage#value}
    */
    readonly value: string;
}
export declare function stageTagToTerraform(struct?: StageTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/stage snowflake_stage}
*/
export declare class Stage extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stage";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/stage snowflake_stage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StageConfig
    */
    constructor(scope: Construct, id: string, config: StageConfig);
    private _awsExternalId?;
    get awsExternalId(): string;
    set awsExternalId(value: string);
    resetAwsExternalId(): void;
    get awsExternalIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyOptions?;
    get copyOptions(): string;
    set copyOptions(value: string);
    resetCopyOptions(): void;
    get copyOptionsInput(): string | undefined;
    private _credentials?;
    get credentials(): string;
    set credentials(value: string);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _encryption?;
    get encryption(): string;
    set encryption(value: string);
    resetEncryption(): void;
    get encryptionInput(): string | undefined;
    private _fileFormat?;
    get fileFormat(): string;
    set fileFormat(value: string);
    resetFileFormat(): void;
    get fileFormatInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _snowflakeIamUser?;
    get snowflakeIamUser(): string;
    set snowflakeIamUser(value: string);
    resetSnowflakeIamUser(): void;
    get snowflakeIamUserInput(): string | undefined;
    private _storageIntegration?;
    get storageIntegration(): string;
    set storageIntegration(value: string);
    resetStorageIntegration(): void;
    get storageIntegrationInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _tag?;
    get tag(): StageTag[] | cdktf.IResolvable;
    set tag(value: StageTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | StageTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=stage.d.ts.map